/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.CategorizationAnalyzer;
import co.elastic.clients.elasticsearch.ml.Detector;
import co.elastic.clients.elasticsearch.ml.PerPartitionCategorization;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class AnalysisConfigRead
implements JsonpSerializable {
    private final String bucketSpan;
    @Nullable
    private final CategorizationAnalyzer categorizationAnalyzer;
    @Nullable
    private final String categorizationFieldName;
    @Nullable
    private final List<String> categorizationFilters;
    private final List<Detector> detectors;
    private final List<String> influencers;
    @Nullable
    private final String modelPruneWindow;
    @Nullable
    private final String latency;
    @Nullable
    private final Boolean multivariateByFields;
    @Nullable
    private final PerPartitionCategorization perPartitionCategorization;
    @Nullable
    private final String summaryCountFieldName;
    public static final JsonpDeserializer<AnalysisConfigRead> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AnalysisConfigRead::setupAnalysisConfigReadDeserializer, Builder::build);

    public AnalysisConfigRead(Builder builder) {
        this.bucketSpan = Objects.requireNonNull(builder.bucketSpan, "bucket_span");
        this.categorizationAnalyzer = builder.categorizationAnalyzer;
        this.categorizationFieldName = builder.categorizationFieldName;
        this.categorizationFilters = ModelTypeHelper.unmodifiable(builder.categorizationFilters);
        this.detectors = ModelTypeHelper.unmodifiableNonNull(builder.detectors, "detectors");
        this.influencers = ModelTypeHelper.unmodifiableNonNull(builder.influencers, "influencers");
        this.modelPruneWindow = builder.modelPruneWindow;
        this.latency = builder.latency;
        this.multivariateByFields = builder.multivariateByFields;
        this.perPartitionCategorization = builder.perPartitionCategorization;
        this.summaryCountFieldName = builder.summaryCountFieldName;
    }

    public AnalysisConfigRead(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String bucketSpan() {
        return this.bucketSpan;
    }

    @Nullable
    public CategorizationAnalyzer categorizationAnalyzer() {
        return this.categorizationAnalyzer;
    }

    @Nullable
    public String categorizationFieldName() {
        return this.categorizationFieldName;
    }

    @Nullable
    public List<String> categorizationFilters() {
        return this.categorizationFilters;
    }

    public List<Detector> detectors() {
        return this.detectors;
    }

    public List<String> influencers() {
        return this.influencers;
    }

    @Nullable
    public String modelPruneWindow() {
        return this.modelPruneWindow;
    }

    @Nullable
    public String latency() {
        return this.latency;
    }

    @Nullable
    public Boolean multivariateByFields() {
        return this.multivariateByFields;
    }

    @Nullable
    public PerPartitionCategorization perPartitionCategorization() {
        return this.perPartitionCategorization;
    }

    @Nullable
    public String summaryCountFieldName() {
        return this.summaryCountFieldName;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bucket_span");
        generator.write(this.bucketSpan);
        if (this.categorizationAnalyzer != null) {
            generator.writeKey("categorization_analyzer");
            this.categorizationAnalyzer.serialize(generator, mapper);
        }
        if (this.categorizationFieldName != null) {
            generator.writeKey("categorization_field_name");
            generator.write(this.categorizationFieldName);
        }
        if (this.categorizationFilters != null) {
            generator.writeKey("categorization_filters");
            generator.writeStartArray();
            for (String string : this.categorizationFilters) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        generator.writeKey("detectors");
        generator.writeStartArray();
        for (Detector detector : this.detectors) {
            detector.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("influencers");
        generator.writeStartArray();
        for (String string : this.influencers) {
            generator.write(string);
        }
        generator.writeEnd();
        if (this.modelPruneWindow != null) {
            generator.writeKey("model_prune_window");
            generator.write(this.modelPruneWindow);
        }
        if (this.latency != null) {
            generator.writeKey("latency");
            generator.write(this.latency);
        }
        if (this.multivariateByFields != null) {
            generator.writeKey("multivariate_by_fields");
            generator.write(this.multivariateByFields.booleanValue());
        }
        if (this.perPartitionCategorization != null) {
            generator.writeKey("per_partition_categorization");
            this.perPartitionCategorization.serialize(generator, mapper);
        }
        if (this.summaryCountFieldName != null) {
            generator.writeKey("summary_count_field_name");
            generator.write(this.summaryCountFieldName);
        }
    }

    protected static void setupAnalysisConfigReadDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::bucketSpan, JsonpDeserializer.stringDeserializer(), "bucket_span", new String[0]);
        op.add(Builder::categorizationAnalyzer, CategorizationAnalyzer._DESERIALIZER, "categorization_analyzer", new String[0]);
        op.add(Builder::categorizationFieldName, JsonpDeserializer.stringDeserializer(), "categorization_field_name", new String[0]);
        op.add(Builder::categorizationFilters, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "categorization_filters", new String[0]);
        op.add(Builder::detectors, JsonpDeserializer.arrayDeserializer(Detector._DESERIALIZER), "detectors", new String[0]);
        op.add(Builder::influencers, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "influencers", new String[0]);
        op.add(Builder::modelPruneWindow, JsonpDeserializer.stringDeserializer(), "model_prune_window", new String[0]);
        op.add(Builder::latency, JsonpDeserializer.stringDeserializer(), "latency", new String[0]);
        op.add(Builder::multivariateByFields, JsonpDeserializer.booleanDeserializer(), "multivariate_by_fields", new String[0]);
        op.add(Builder::perPartitionCategorization, PerPartitionCategorization._DESERIALIZER, "per_partition_categorization", new String[0]);
        op.add(Builder::summaryCountFieldName, JsonpDeserializer.stringDeserializer(), "summary_count_field_name", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<AnalysisConfigRead> {
        private String bucketSpan;
        @Nullable
        private CategorizationAnalyzer categorizationAnalyzer;
        @Nullable
        private String categorizationFieldName;
        @Nullable
        private List<String> categorizationFilters;
        private List<Detector> detectors;
        private List<String> influencers;
        @Nullable
        private String modelPruneWindow;
        @Nullable
        private String latency;
        @Nullable
        private Boolean multivariateByFields;
        @Nullable
        private PerPartitionCategorization perPartitionCategorization;
        @Nullable
        private String summaryCountFieldName;

        public Builder bucketSpan(String value) {
            this.bucketSpan = value;
            return this;
        }

        public Builder categorizationAnalyzer(@Nullable CategorizationAnalyzer value) {
            this.categorizationAnalyzer = value;
            return this;
        }

        public Builder categorizationAnalyzer(Function<CategorizationAnalyzer.Builder, ObjectBuilder<CategorizationAnalyzer>> fn) {
            return this.categorizationAnalyzer(fn.apply(new CategorizationAnalyzer.Builder()).build());
        }

        public Builder categorizationFieldName(@Nullable String value) {
            this.categorizationFieldName = value;
            return this;
        }

        public Builder categorizationFilters(@Nullable List<String> value) {
            this.categorizationFilters = value;
            return this;
        }

        public Builder categorizationFilters(String ... value) {
            this.categorizationFilters = Arrays.asList(value);
            return this;
        }

        public Builder addCategorizationFilters(String value) {
            if (this.categorizationFilters == null) {
                this.categorizationFilters = new ArrayList<String>();
            }
            this.categorizationFilters.add(value);
            return this;
        }

        public Builder detectors(List<Detector> value) {
            this.detectors = value;
            return this;
        }

        public Builder detectors(Detector ... value) {
            this.detectors = Arrays.asList(value);
            return this;
        }

        public Builder addDetectors(Detector value) {
            if (this.detectors == null) {
                this.detectors = new ArrayList<Detector>();
            }
            this.detectors.add(value);
            return this;
        }

        public Builder detectors(Function<Detector.Builder, ObjectBuilder<Detector>> fn) {
            return this.detectors(fn.apply(new Detector.Builder()).build());
        }

        public Builder addDetectors(Function<Detector.Builder, ObjectBuilder<Detector>> fn) {
            return this.addDetectors(fn.apply(new Detector.Builder()).build());
        }

        public Builder influencers(List<String> value) {
            this.influencers = value;
            return this;
        }

        public Builder influencers(String ... value) {
            this.influencers = Arrays.asList(value);
            return this;
        }

        public Builder addInfluencers(String value) {
            if (this.influencers == null) {
                this.influencers = new ArrayList<String>();
            }
            this.influencers.add(value);
            return this;
        }

        public Builder modelPruneWindow(@Nullable String value) {
            this.modelPruneWindow = value;
            return this;
        }

        public Builder latency(@Nullable String value) {
            this.latency = value;
            return this;
        }

        public Builder multivariateByFields(@Nullable Boolean value) {
            this.multivariateByFields = value;
            return this;
        }

        public Builder perPartitionCategorization(@Nullable PerPartitionCategorization value) {
            this.perPartitionCategorization = value;
            return this;
        }

        public Builder perPartitionCategorization(Function<PerPartitionCategorization.Builder, ObjectBuilder<PerPartitionCategorization>> fn) {
            return this.perPartitionCategorization(fn.apply(new PerPartitionCategorization.Builder()).build());
        }

        public Builder summaryCountFieldName(@Nullable String value) {
            this.summaryCountFieldName = value;
            return this;
        }

        @Override
        public AnalysisConfigRead build() {
            return new AnalysisConfigRead(this);
        }
    }
}

