/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.logstash;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class PipelineMetadata
implements JsonpSerializable {
    private final String type;
    private final String version;
    public static final JsonpDeserializer<PipelineMetadata> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PipelineMetadata::setupPipelineMetadataDeserializer, Builder::build);

    public PipelineMetadata(Builder builder) {
        this.type = Objects.requireNonNull(builder.type, "type");
        this.version = Objects.requireNonNull(builder.version, "version");
    }

    public PipelineMetadata(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String type() {
        return this.type;
    }

    public String version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("type");
        generator.write(this.type);
        generator.writeKey("version");
        generator.write(this.version);
    }

    protected static void setupPipelineMetadataDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type", new String[0]);
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PipelineMetadata> {
        private String type;
        private String version;

        public Builder type(String value) {
            this.type = value;
            return this;
        }

        public Builder version(String value) {
            this.version = value;
            return this;
        }

        @Override
        public PipelineMetadata build() {
            return new PipelineMetadata(this);
        }
    }
}

