/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest.simulate;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Ingest
implements JsonpSerializable {
    private final String timestamp;
    @Nullable
    private final String pipeline;
    public static final JsonpDeserializer<Ingest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Ingest::setupIngestDeserializer, Builder::build);

    public Ingest(Builder builder) {
        this.timestamp = Objects.requireNonNull(builder.timestamp, "timestamp");
        this.pipeline = builder.pipeline;
    }

    public Ingest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String timestamp() {
        return this.timestamp;
    }

    @Nullable
    public String pipeline() {
        return this.pipeline;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
        if (this.pipeline != null) {
            generator.writeKey("pipeline");
            generator.write(this.pipeline);
        }
    }

    protected static void setupIngestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::timestamp, JsonpDeserializer.stringDeserializer(), "timestamp", new String[0]);
        op.add(Builder::pipeline, JsonpDeserializer.stringDeserializer(), "pipeline", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Ingest> {
        private String timestamp;
        @Nullable
        private String pipeline;

        public Builder timestamp(String value) {
            this.timestamp = value;
            return this;
        }

        public Builder pipeline(@Nullable String value) {
            this.pipeline = value;
            return this;
        }

        @Override
        public Ingest build() {
            return new Ingest(this);
        }
    }
}

