/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest.simulate;

import co.elastic.clients.elasticsearch.ingest.simulate.Ingest;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DocumentSimulation
implements JsonpSerializable {
    private final String id;
    private final String index;
    private final Ingest ingest;
    @Nullable
    private final String parent;
    @Nullable
    private final String routing;
    private final Map<String, JsonData> source;
    @Nullable
    private final String type;
    public static final JsonpDeserializer<DocumentSimulation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DocumentSimulation::setupDocumentSimulationDeserializer, Builder::build);

    public DocumentSimulation(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "_id");
        this.index = Objects.requireNonNull(builder.index, "_index");
        this.ingest = Objects.requireNonNull(builder.ingest, "_ingest");
        this.parent = builder.parent;
        this.routing = builder.routing;
        this.source = ModelTypeHelper.unmodifiableNonNull(builder.source, "_source");
        this.type = builder.type;
    }

    public DocumentSimulation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    public String index() {
        return this.index;
    }

    public Ingest ingest() {
        return this.ingest;
    }

    @Nullable
    public String parent() {
        return this.parent;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    public Map<String, JsonData> source() {
        return this.source;
    }

    @Nullable
    public String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_id");
        generator.write(this.id);
        generator.writeKey("_index");
        generator.write(this.index);
        generator.writeKey("_ingest");
        this.ingest.serialize(generator, mapper);
        if (this.parent != null) {
            generator.writeKey("_parent");
            generator.write(this.parent);
        }
        if (this.routing != null) {
            generator.writeKey("_routing");
            generator.write(this.routing);
        }
        generator.writeKey("_source");
        generator.writeStartObject();
        for (Map.Entry<String, JsonData> item0 : this.source.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.type != null) {
            generator.writeKey("_type");
            generator.write(this.type);
        }
    }

    protected static void setupDocumentSimulationDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id", new String[0]);
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index", new String[0]);
        op.add(Builder::ingest, Ingest._DESERIALIZER, "_ingest", new String[0]);
        op.add(Builder::parent, JsonpDeserializer.stringDeserializer(), "_parent", new String[0]);
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "_routing", new String[0]);
        op.add(Builder::source, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_source", new String[0]);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "_type", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DocumentSimulation> {
        private String id;
        private String index;
        private Ingest ingest;
        @Nullable
        private String parent;
        @Nullable
        private String routing;
        private Map<String, JsonData> source;
        @Nullable
        private String type;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder ingest(Ingest value) {
            this.ingest = value;
            return this;
        }

        public Builder ingest(Function<Ingest.Builder, ObjectBuilder<Ingest>> fn) {
            return this.ingest(fn.apply(new Ingest.Builder()).build());
        }

        public Builder parent(@Nullable String value) {
            this.parent = value;
            return this;
        }

        public Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public Builder source(Map<String, JsonData> value) {
            this.source = value;
            return this;
        }

        public Builder putSource(String key, JsonData value) {
            if (this.source == null) {
                this.source = new HashMap<String, JsonData>();
            }
            this.source.put(key, value);
            return this;
        }

        public Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        @Override
        public DocumentSimulation build() {
            return new DocumentSimulation(this);
        }
    }
}

