/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest.geo_ip_stats;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class GeoIpDownloadStatistics
implements JsonpSerializable {
    private final int successfulDownloads;
    private final int failedDownloads;
    private final int totalDownloadTime;
    private final int databaseCount;
    private final int skippedUpdates;
    public static final JsonpDeserializer<GeoIpDownloadStatistics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoIpDownloadStatistics::setupGeoIpDownloadStatisticsDeserializer, Builder::build);

    public GeoIpDownloadStatistics(Builder builder) {
        this.successfulDownloads = Objects.requireNonNull(builder.successfulDownloads, "successful_downloads");
        this.failedDownloads = Objects.requireNonNull(builder.failedDownloads, "failed_downloads");
        this.totalDownloadTime = Objects.requireNonNull(builder.totalDownloadTime, "total_download_time");
        this.databaseCount = Objects.requireNonNull(builder.databaseCount, "database_count");
        this.skippedUpdates = Objects.requireNonNull(builder.skippedUpdates, "skipped_updates");
    }

    public GeoIpDownloadStatistics(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int successfulDownloads() {
        return this.successfulDownloads;
    }

    public int failedDownloads() {
        return this.failedDownloads;
    }

    public int totalDownloadTime() {
        return this.totalDownloadTime;
    }

    public int databaseCount() {
        return this.databaseCount;
    }

    public int skippedUpdates() {
        return this.skippedUpdates;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("successful_downloads");
        generator.write(this.successfulDownloads);
        generator.writeKey("failed_downloads");
        generator.write(this.failedDownloads);
        generator.writeKey("total_download_time");
        generator.write(this.totalDownloadTime);
        generator.writeKey("database_count");
        generator.write(this.databaseCount);
        generator.writeKey("skipped_updates");
        generator.write(this.skippedUpdates);
    }

    protected static void setupGeoIpDownloadStatisticsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::successfulDownloads, JsonpDeserializer.integerDeserializer(), "successful_downloads", new String[0]);
        op.add(Builder::failedDownloads, JsonpDeserializer.integerDeserializer(), "failed_downloads", new String[0]);
        op.add(Builder::totalDownloadTime, JsonpDeserializer.integerDeserializer(), "total_download_time", new String[0]);
        op.add(Builder::databaseCount, JsonpDeserializer.integerDeserializer(), "database_count", new String[0]);
        op.add(Builder::skippedUpdates, JsonpDeserializer.integerDeserializer(), "skipped_updates", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GeoIpDownloadStatistics> {
        private Integer successfulDownloads;
        private Integer failedDownloads;
        private Integer totalDownloadTime;
        private Integer databaseCount;
        private Integer skippedUpdates;

        public Builder successfulDownloads(int value) {
            this.successfulDownloads = value;
            return this;
        }

        public Builder failedDownloads(int value) {
            this.failedDownloads = value;
            return this;
        }

        public Builder totalDownloadTime(int value) {
            this.totalDownloadTime = value;
            return this;
        }

        public Builder databaseCount(int value) {
            this.databaseCount = value;
            return this;
        }

        public Builder skippedUpdates(int value) {
            this.skippedUpdates = value;
            return this;
        }

        @Override
        public GeoIpDownloadStatistics build() {
            return new GeoIpDownloadStatistics(this);
        }
    }
}

