/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SetSecurityUserProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    @Nullable
    private final List<String> properties;
    public static final JsonpDeserializer<SetSecurityUserProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SetSecurityUserProcessor::setupSetSecurityUserProcessorDeserializer, Builder::build);

    public SetSecurityUserProcessor(Builder builder) {
        super(builder);
        this.field = Objects.requireNonNull(builder.field, "field");
        this.properties = ModelTypeHelper.unmodifiable(builder.properties);
    }

    public SetSecurityUserProcessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "set_security_user";
    }

    public String field() {
        return this.field;
    }

    @Nullable
    public List<String> properties() {
        return this.properties;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.properties != null) {
            generator.writeKey("properties");
            generator.writeStartArray();
            for (String item0 : this.properties) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupSetSecurityUserProcessorDeserializer(DelegatingDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::properties, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "properties", new String[0]);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SetSecurityUserProcessor> {
        private String field;
        @Nullable
        private List<String> properties;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder properties(@Nullable List<String> value) {
            this.properties = value;
            return this;
        }

        public Builder properties(String ... value) {
            this.properties = Arrays.asList(value);
            return this;
        }

        public Builder addProperties(String value) {
            if (this.properties == null) {
                this.properties = new ArrayList<String>();
            }
            this.properties.add(value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SetSecurityUserProcessor build() {
            return new SetSecurityUserProcessor(this);
        }
    }
}

