/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.stats;

import co.elastic.clients.elasticsearch.indices.stats.ShardRoutingState;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ShardRouting
implements JsonpSerializable {
    private final String node;
    private final boolean primary;
    @Nullable
    private final String relocatingNode;
    private final ShardRoutingState state;
    public static final JsonpDeserializer<ShardRouting> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardRouting::setupShardRoutingDeserializer, Builder::build);

    public ShardRouting(Builder builder) {
        this.node = Objects.requireNonNull(builder.node, "node");
        this.primary = Objects.requireNonNull(builder.primary, "primary");
        this.relocatingNode = builder.relocatingNode;
        this.state = Objects.requireNonNull(builder.state, "state");
    }

    public ShardRouting(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String node() {
        return this.node;
    }

    public boolean primary() {
        return this.primary;
    }

    @Nullable
    public String relocatingNode() {
        return this.relocatingNode;
    }

    public ShardRoutingState state() {
        return this.state;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("node");
        generator.write(this.node);
        generator.writeKey("primary");
        generator.write(this.primary);
        if (this.relocatingNode != null) {
            generator.writeKey("relocating_node");
            generator.write(this.relocatingNode);
        }
        generator.writeKey("state");
        this.state.serialize(generator, mapper);
    }

    protected static void setupShardRoutingDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "node", new String[0]);
        op.add(Builder::primary, JsonpDeserializer.booleanDeserializer(), "primary", new String[0]);
        op.add(Builder::relocatingNode, JsonpDeserializer.stringDeserializer(), "relocating_node", new String[0]);
        op.add(Builder::state, ShardRoutingState._DESERIALIZER, "state", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ShardRouting> {
        private String node;
        private Boolean primary;
        @Nullable
        private String relocatingNode;
        private ShardRoutingState state;

        public Builder node(String value) {
            this.node = value;
            return this;
        }

        public Builder primary(boolean value) {
            this.primary = value;
            return this;
        }

        public Builder relocatingNode(@Nullable String value) {
            this.relocatingNode = value;
            return this;
        }

        public Builder state(ShardRoutingState value) {
            this.state = value;
            return this;
        }

        @Override
        public ShardRouting build() {
            return new ShardRouting(this);
        }
    }
}

