/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.simulate_template;

import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch.indices.Alias;
import co.elastic.clients.elasticsearch.indices.simulate_template.Overlapping;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Template
implements JsonpSerializable {
    private final Map<String, Alias> aliases;
    private final TypeMapping mappings;
    private final Map<String, JsonData> settings;
    private final List<Overlapping> overlapping;
    public static final JsonpDeserializer<Template> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Template::setupTemplateDeserializer, Builder::build);

    public Template(Builder builder) {
        this.aliases = ModelTypeHelper.unmodifiableNonNull(builder.aliases, "aliases");
        this.mappings = Objects.requireNonNull(builder.mappings, "mappings");
        this.settings = ModelTypeHelper.unmodifiableNonNull(builder.settings, "settings");
        this.overlapping = ModelTypeHelper.unmodifiableNonNull(builder.overlapping, "overlapping");
    }

    public Template(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, Alias> aliases() {
        return this.aliases;
    }

    public TypeMapping mappings() {
        return this.mappings;
    }

    public Map<String, JsonData> settings() {
        return this.settings;
    }

    public List<Overlapping> overlapping() {
        return this.overlapping;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("aliases");
        generator.writeStartObject();
        for (Map.Entry<String, Alias> entry : this.aliases.entrySet()) {
            generator.writeKey(entry.getKey());
            entry.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("mappings");
        this.mappings.serialize(generator, mapper);
        generator.writeKey("settings");
        generator.writeStartObject();
        for (Map.Entry<String, JsonpSerializable> entry : this.settings.entrySet()) {
            generator.writeKey(entry.getKey());
            ((JsonData)entry.getValue()).serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("overlapping");
        generator.writeStartArray();
        for (Overlapping overlapping : this.overlapping) {
            overlapping.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupTemplateDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::aliases, JsonpDeserializer.stringMapDeserializer(Alias._DESERIALIZER), "aliases", new String[0]);
        op.add(Builder::mappings, TypeMapping._DESERIALIZER, "mappings", new String[0]);
        op.add(Builder::settings, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "settings", new String[0]);
        op.add(Builder::overlapping, JsonpDeserializer.arrayDeserializer(Overlapping._DESERIALIZER), "overlapping", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Template> {
        private Map<String, Alias> aliases;
        private TypeMapping mappings;
        private Map<String, JsonData> settings;
        private List<Overlapping> overlapping;

        public Builder aliases(Map<String, Alias> value) {
            this.aliases = value;
            return this;
        }

        public Builder putAliases(String key, Alias value) {
            if (this.aliases == null) {
                this.aliases = new HashMap<String, Alias>();
            }
            this.aliases.put(key, value);
            return this;
        }

        public Builder aliases(String key, Function<Alias.Builder, ObjectBuilder<Alias>> fn) {
            return this.aliases(Collections.singletonMap(key, fn.apply(new Alias.Builder()).build()));
        }

        public Builder putAliases(String key, Function<Alias.Builder, ObjectBuilder<Alias>> fn) {
            return this.putAliases(key, fn.apply(new Alias.Builder()).build());
        }

        public Builder mappings(TypeMapping value) {
            this.mappings = value;
            return this;
        }

        public Builder mappings(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.mappings(fn.apply(new TypeMapping.Builder()).build());
        }

        public Builder settings(Map<String, JsonData> value) {
            this.settings = value;
            return this;
        }

        public Builder putSettings(String key, JsonData value) {
            if (this.settings == null) {
                this.settings = new HashMap<String, JsonData>();
            }
            this.settings.put(key, value);
            return this;
        }

        public Builder overlapping(List<Overlapping> value) {
            this.overlapping = value;
            return this;
        }

        public Builder overlapping(Overlapping ... value) {
            this.overlapping = Arrays.asList(value);
            return this;
        }

        public Builder addOverlapping(Overlapping value) {
            if (this.overlapping == null) {
                this.overlapping = new ArrayList<Overlapping>();
            }
            this.overlapping.add(value);
            return this;
        }

        public Builder overlapping(Function<Overlapping.Builder, ObjectBuilder<Overlapping>> fn) {
            return this.overlapping(fn.apply(new Overlapping.Builder()).build());
        }

        public Builder addOverlapping(Function<Overlapping.Builder, ObjectBuilder<Overlapping>> fn) {
            return this.addOverlapping(fn.apply(new Overlapping.Builder()).build());
        }

        @Override
        public Template build() {
            return new Template(this);
        }
    }
}

