/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.shard_stores;

import co.elastic.clients.elasticsearch.indices.shard_stores.ShardStoreAllocation;
import co.elastic.clients.elasticsearch.indices.shard_stores.ShardStoreException;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ShardStore
implements JsonpSerializable {
    private final ShardStoreAllocation allocation;
    private final String allocationId;
    private final Map<String, JsonData> attributes;
    private final String id;
    private final long legacyVersion;
    private final String name;
    private final ShardStoreException storeException;
    private final String transportAddress;
    public static final JsonpDeserializer<ShardStore> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardStore::setupShardStoreDeserializer, Builder::build);

    public ShardStore(Builder builder) {
        this.allocation = Objects.requireNonNull(builder.allocation, "allocation");
        this.allocationId = Objects.requireNonNull(builder.allocationId, "allocation_id");
        this.attributes = ModelTypeHelper.unmodifiableNonNull(builder.attributes, "attributes");
        this.id = Objects.requireNonNull(builder.id, "id");
        this.legacyVersion = Objects.requireNonNull(builder.legacyVersion, "legacy_version");
        this.name = Objects.requireNonNull(builder.name, "name");
        this.storeException = Objects.requireNonNull(builder.storeException, "store_exception");
        this.transportAddress = Objects.requireNonNull(builder.transportAddress, "transport_address");
    }

    public ShardStore(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public ShardStoreAllocation allocation() {
        return this.allocation;
    }

    public String allocationId() {
        return this.allocationId;
    }

    public Map<String, JsonData> attributes() {
        return this.attributes;
    }

    public String id() {
        return this.id;
    }

    public long legacyVersion() {
        return this.legacyVersion;
    }

    public String name() {
        return this.name;
    }

    public ShardStoreException storeException() {
        return this.storeException;
    }

    public String transportAddress() {
        return this.transportAddress;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("allocation");
        this.allocation.serialize(generator, mapper);
        generator.writeKey("allocation_id");
        generator.write(this.allocationId);
        generator.writeKey("attributes");
        generator.writeStartObject();
        for (Map.Entry<String, JsonData> item0 : this.attributes.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("legacy_version");
        generator.write(this.legacyVersion);
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("store_exception");
        this.storeException.serialize(generator, mapper);
        generator.writeKey("transport_address");
        generator.write(this.transportAddress);
    }

    protected static void setupShardStoreDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::allocation, ShardStoreAllocation._DESERIALIZER, "allocation", new String[0]);
        op.add(Builder::allocationId, JsonpDeserializer.stringDeserializer(), "allocation_id", new String[0]);
        op.add(Builder::attributes, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "attributes", new String[0]);
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id", new String[0]);
        op.add(Builder::legacyVersion, JsonpDeserializer.longDeserializer(), "legacy_version", new String[0]);
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::storeException, ShardStoreException._DESERIALIZER, "store_exception", new String[0]);
        op.add(Builder::transportAddress, JsonpDeserializer.stringDeserializer(), "transport_address", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ShardStore> {
        private ShardStoreAllocation allocation;
        private String allocationId;
        private Map<String, JsonData> attributes;
        private String id;
        private Long legacyVersion;
        private String name;
        private ShardStoreException storeException;
        private String transportAddress;

        public Builder allocation(ShardStoreAllocation value) {
            this.allocation = value;
            return this;
        }

        public Builder allocationId(String value) {
            this.allocationId = value;
            return this;
        }

        public Builder attributes(Map<String, JsonData> value) {
            this.attributes = value;
            return this;
        }

        public Builder putAttributes(String key, JsonData value) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, JsonData>();
            }
            this.attributes.put(key, value);
            return this;
        }

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder legacyVersion(long value) {
            this.legacyVersion = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder storeException(ShardStoreException value) {
            this.storeException = value;
            return this;
        }

        public Builder storeException(Function<ShardStoreException.Builder, ObjectBuilder<ShardStoreException>> fn) {
            return this.storeException(fn.apply(new ShardStoreException.Builder()).build());
        }

        public Builder transportAddress(String value) {
            this.transportAddress = value;
            return this;
        }

        @Override
        public ShardStore build() {
            return new ShardStore(this);
        }
    }
}

