/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.recovery;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class FileDetails
implements JsonpSerializable {
    private final long length;
    private final String name;
    private final long recovered;
    public static final JsonpDeserializer<FileDetails> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FileDetails::setupFileDetailsDeserializer, Builder::build);

    public FileDetails(Builder builder) {
        this.length = Objects.requireNonNull(builder.length, "length");
        this.name = Objects.requireNonNull(builder.name, "name");
        this.recovered = Objects.requireNonNull(builder.recovered, "recovered");
    }

    public FileDetails(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long length() {
        return this.length;
    }

    public String name() {
        return this.name;
    }

    public long recovered() {
        return this.recovered;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("length");
        generator.write(this.length);
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("recovered");
        generator.write(this.recovered);
    }

    protected static void setupFileDetailsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::length, JsonpDeserializer.longDeserializer(), "length", new String[0]);
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::recovered, JsonpDeserializer.longDeserializer(), "recovered", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FileDetails> {
        private Long length;
        private String name;
        private Long recovered;

        public Builder length(long value) {
            this.length = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder recovered(long value) {
            this.recovered = value;
            return this;
        }

        @Override
        public FileDetails build() {
            return new FileDetails(this);
        }
    }
}

