/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.get_field_mapping;

import co.elastic.clients.elasticsearch._types.mapping.FieldMapping;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public final class TypeFieldMappings
implements JsonpSerializable {
    private final Map<String, FieldMapping> mappings;
    public static final JsonpDeserializer<TypeFieldMappings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TypeFieldMappings::setupTypeFieldMappingsDeserializer, Builder::build);

    public TypeFieldMappings(Builder builder) {
        this.mappings = ModelTypeHelper.unmodifiableNonNull(builder.mappings, "mappings");
    }

    public TypeFieldMappings(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, FieldMapping> mappings() {
        return this.mappings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("mappings");
        generator.writeStartObject();
        for (Map.Entry<String, FieldMapping> item0 : this.mappings.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupTypeFieldMappingsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::mappings, JsonpDeserializer.stringMapDeserializer(FieldMapping._DESERIALIZER), "mappings", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TypeFieldMappings> {
        private Map<String, FieldMapping> mappings;

        public Builder mappings(Map<String, FieldMapping> value) {
            this.mappings = value;
            return this;
        }

        public Builder putMappings(String key, FieldMapping value) {
            if (this.mappings == null) {
                this.mappings = new HashMap<String, FieldMapping>();
            }
            this.mappings.put(key, value);
            return this;
        }

        public Builder mappings(String key, Function<FieldMapping.Builder, ObjectBuilder<FieldMapping>> fn) {
            return this.mappings(Collections.singletonMap(key, fn.apply(new FieldMapping.Builder()).build()));
        }

        public Builder putMappings(String key, Function<FieldMapping.Builder, ObjectBuilder<FieldMapping>> fn) {
            return this.putMappings(key, fn.apply(new FieldMapping.Builder()).build());
        }

        @Override
        public TypeFieldMappings build() {
            return new TypeFieldMappings(this);
        }
    }
}

