/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.data_streams_stats;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DataStreamsStatsItem
implements JsonpSerializable {
    private final int backingIndices;
    private final String dataStream;
    @Nullable
    private final String storeSize;
    private final int storeSizeBytes;
    private final int maximumTimestamp;
    public static final JsonpDeserializer<DataStreamsStatsItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreamsStatsItem::setupDataStreamsStatsItemDeserializer, Builder::build);

    public DataStreamsStatsItem(Builder builder) {
        this.backingIndices = Objects.requireNonNull(builder.backingIndices, "backing_indices");
        this.dataStream = Objects.requireNonNull(builder.dataStream, "data_stream");
        this.storeSize = builder.storeSize;
        this.storeSizeBytes = Objects.requireNonNull(builder.storeSizeBytes, "store_size_bytes");
        this.maximumTimestamp = Objects.requireNonNull(builder.maximumTimestamp, "maximum_timestamp");
    }

    public DataStreamsStatsItem(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int backingIndices() {
        return this.backingIndices;
    }

    public String dataStream() {
        return this.dataStream;
    }

    @Nullable
    public String storeSize() {
        return this.storeSize;
    }

    public int storeSizeBytes() {
        return this.storeSizeBytes;
    }

    public int maximumTimestamp() {
        return this.maximumTimestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("backing_indices");
        generator.write(this.backingIndices);
        generator.writeKey("data_stream");
        generator.write(this.dataStream);
        if (this.storeSize != null) {
            generator.writeKey("store_size");
            generator.write(this.storeSize);
        }
        generator.writeKey("store_size_bytes");
        generator.write(this.storeSizeBytes);
        generator.writeKey("maximum_timestamp");
        generator.write(this.maximumTimestamp);
    }

    protected static void setupDataStreamsStatsItemDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::backingIndices, JsonpDeserializer.integerDeserializer(), "backing_indices", new String[0]);
        op.add(Builder::dataStream, JsonpDeserializer.stringDeserializer(), "data_stream", new String[0]);
        op.add(Builder::storeSize, JsonpDeserializer.stringDeserializer(), "store_size", new String[0]);
        op.add(Builder::storeSizeBytes, JsonpDeserializer.integerDeserializer(), "store_size_bytes", new String[0]);
        op.add(Builder::maximumTimestamp, JsonpDeserializer.integerDeserializer(), "maximum_timestamp", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DataStreamsStatsItem> {
        private Integer backingIndices;
        private String dataStream;
        @Nullable
        private String storeSize;
        private Integer storeSizeBytes;
        private Integer maximumTimestamp;

        public Builder backingIndices(int value) {
            this.backingIndices = value;
            return this;
        }

        public Builder dataStream(String value) {
            this.dataStream = value;
            return this;
        }

        public Builder storeSize(@Nullable String value) {
            this.storeSize = value;
            return this;
        }

        public Builder storeSizeBytes(int value) {
            this.storeSizeBytes = value;
            return this;
        }

        public Builder maximumTimestamp(int value) {
            this.maximumTimestamp = value;
            return this;
        }

        @Override
        public DataStreamsStatsItem build() {
            return new DataStreamsStatsItem(this);
        }
    }
}

