/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.analyze;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class CharFilterDetail
implements JsonpSerializable {
    private final List<String> filteredText;
    private final String name;
    public static final JsonpDeserializer<CharFilterDetail> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CharFilterDetail::setupCharFilterDetailDeserializer, Builder::build);

    public CharFilterDetail(Builder builder) {
        this.filteredText = ModelTypeHelper.unmodifiableNonNull(builder.filteredText, "filtered_text");
        this.name = Objects.requireNonNull(builder.name, "name");
    }

    public CharFilterDetail(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> filteredText() {
        return this.filteredText;
    }

    public String name() {
        return this.name;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("filtered_text");
        generator.writeStartArray();
        for (String item0 : this.filteredText) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("name");
        generator.write(this.name);
    }

    protected static void setupCharFilterDetailDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::filteredText, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "filtered_text", new String[0]);
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<CharFilterDetail> {
        private List<String> filteredText;
        private String name;

        public Builder filteredText(List<String> value) {
            this.filteredText = value;
            return this;
        }

        public Builder filteredText(String ... value) {
            this.filteredText = Arrays.asList(value);
            return this;
        }

        public Builder addFilteredText(String value) {
            if (this.filteredText == null) {
                this.filteredText = new ArrayList<String>();
            }
            this.filteredText.add(value);
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        @Override
        public CharFilterDetail build() {
            return new CharFilterDetail(this);
        }
    }
}

