/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.elasticsearch.indices.stats.IndicesStats;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class StatsResponse
implements JsonpSerializable {
    @Nullable
    private final Map<String, IndicesStats> indices;
    private final ShardStatistics shards;
    private final IndicesStats all;
    public static final JsonpDeserializer<StatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StatsResponse::setupStatsResponseDeserializer, Builder::build);

    public StatsResponse(Builder builder) {
        this.indices = ModelTypeHelper.unmodifiable(builder.indices);
        this.shards = Objects.requireNonNull(builder.shards, "_shards");
        this.all = Objects.requireNonNull(builder.all, "_all");
    }

    public StatsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Map<String, IndicesStats> indices() {
        return this.indices;
    }

    public ShardStatistics shards() {
        return this.shards;
    }

    public IndicesStats all() {
        return this.all;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.indices != null) {
            generator.writeKey("indices");
            generator.writeStartObject();
            for (Map.Entry<String, IndicesStats> item0 : this.indices.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
        generator.writeKey("_all");
        this.all.serialize(generator, mapper);
    }

    protected static void setupStatsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::indices, JsonpDeserializer.stringMapDeserializer(IndicesStats._DESERIALIZER), "indices", new String[0]);
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards", new String[0]);
        op.add(Builder::all, IndicesStats._DESERIALIZER, "_all", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<StatsResponse> {
        @Nullable
        private Map<String, IndicesStats> indices;
        private ShardStatistics shards;
        private IndicesStats all;

        public Builder indices(@Nullable Map<String, IndicesStats> value) {
            this.indices = value;
            return this;
        }

        public Builder putIndices(String key, IndicesStats value) {
            if (this.indices == null) {
                this.indices = new HashMap<String, IndicesStats>();
            }
            this.indices.put(key, value);
            return this;
        }

        public Builder indices(String key, Function<IndicesStats.Builder, ObjectBuilder<IndicesStats>> fn) {
            return this.indices(Collections.singletonMap(key, fn.apply(new IndicesStats.Builder()).build()));
        }

        public Builder putIndices(String key, Function<IndicesStats.Builder, ObjectBuilder<IndicesStats>> fn) {
            return this.putIndices(key, fn.apply(new IndicesStats.Builder()).build());
        }

        public Builder shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public Builder all(IndicesStats value) {
            this.all = value;
            return this;
        }

        public Builder all(Function<IndicesStats.Builder, ObjectBuilder<IndicesStats>> fn) {
            return this.all(fn.apply(new IndicesStats.Builder()).build());
        }

        @Override
        public StatsResponse build() {
            return new StatsResponse(this);
        }
    }
}

