/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.elasticsearch.indices.segments.IndexSegment;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class SegmentsResponse
implements JsonpSerializable {
    private final Map<String, IndexSegment> indices;
    private final ShardStatistics shards;
    public static final JsonpDeserializer<SegmentsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SegmentsResponse::setupSegmentsResponseDeserializer, Builder::build);

    public SegmentsResponse(Builder builder) {
        this.indices = ModelTypeHelper.unmodifiableNonNull(builder.indices, "indices");
        this.shards = Objects.requireNonNull(builder.shards, "_shards");
    }

    public SegmentsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, IndexSegment> indices() {
        return this.indices;
    }

    public ShardStatistics shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("indices");
        generator.writeStartObject();
        for (Map.Entry<String, IndexSegment> item0 : this.indices.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
    }

    protected static void setupSegmentsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::indices, JsonpDeserializer.stringMapDeserializer(IndexSegment._DESERIALIZER), "indices", new String[0]);
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SegmentsResponse> {
        private Map<String, IndexSegment> indices;
        private ShardStatistics shards;

        public Builder indices(Map<String, IndexSegment> value) {
            this.indices = value;
            return this;
        }

        public Builder putIndices(String key, IndexSegment value) {
            if (this.indices == null) {
                this.indices = new HashMap<String, IndexSegment>();
            }
            this.indices.put(key, value);
            return this;
        }

        public Builder indices(String key, Function<IndexSegment.Builder, ObjectBuilder<IndexSegment>> fn) {
            return this.indices(Collections.singletonMap(key, fn.apply(new IndexSegment.Builder()).build()));
        }

        public Builder putIndices(String key, Function<IndexSegment.Builder, ObjectBuilder<IndexSegment>> fn) {
            return this.putIndices(key, fn.apply(new IndexSegment.Builder()).build());
        }

        public Builder shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        @Override
        public SegmentsResponse build() {
            return new SegmentsResponse(this);
        }
    }
}

