/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.resolve_index.ResolveIndexAliasItem;
import co.elastic.clients.elasticsearch.indices.resolve_index.ResolveIndexDataStreamsItem;
import co.elastic.clients.elasticsearch.indices.resolve_index.ResolveIndexItem;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class ResolveIndexResponse
implements JsonpSerializable {
    private final List<ResolveIndexItem> indices;
    private final List<ResolveIndexAliasItem> aliases;
    private final List<ResolveIndexDataStreamsItem> dataStreams;
    public static final JsonpDeserializer<ResolveIndexResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ResolveIndexResponse::setupResolveIndexResponseDeserializer, Builder::build);

    public ResolveIndexResponse(Builder builder) {
        this.indices = ModelTypeHelper.unmodifiableNonNull(builder.indices, "indices");
        this.aliases = ModelTypeHelper.unmodifiableNonNull(builder.aliases, "aliases");
        this.dataStreams = ModelTypeHelper.unmodifiableNonNull(builder.dataStreams, "data_streams");
    }

    public ResolveIndexResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<ResolveIndexItem> indices() {
        return this.indices;
    }

    public List<ResolveIndexAliasItem> aliases() {
        return this.aliases;
    }

    public List<ResolveIndexDataStreamsItem> dataStreams() {
        return this.dataStreams;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("indices");
        generator.writeStartArray();
        for (ResolveIndexItem resolveIndexItem : this.indices) {
            resolveIndexItem.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("aliases");
        generator.writeStartArray();
        for (ResolveIndexAliasItem resolveIndexAliasItem : this.aliases) {
            resolveIndexAliasItem.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("data_streams");
        generator.writeStartArray();
        for (ResolveIndexDataStreamsItem resolveIndexDataStreamsItem : this.dataStreams) {
            resolveIndexDataStreamsItem.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupResolveIndexResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(ResolveIndexItem._DESERIALIZER), "indices", new String[0]);
        op.add(Builder::aliases, JsonpDeserializer.arrayDeserializer(ResolveIndexAliasItem._DESERIALIZER), "aliases", new String[0]);
        op.add(Builder::dataStreams, JsonpDeserializer.arrayDeserializer(ResolveIndexDataStreamsItem._DESERIALIZER), "data_streams", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ResolveIndexResponse> {
        private List<ResolveIndexItem> indices;
        private List<ResolveIndexAliasItem> aliases;
        private List<ResolveIndexDataStreamsItem> dataStreams;

        public Builder indices(List<ResolveIndexItem> value) {
            this.indices = value;
            return this;
        }

        public Builder indices(ResolveIndexItem ... value) {
            this.indices = Arrays.asList(value);
            return this;
        }

        public Builder addIndices(ResolveIndexItem value) {
            if (this.indices == null) {
                this.indices = new ArrayList<ResolveIndexItem>();
            }
            this.indices.add(value);
            return this;
        }

        public Builder indices(Function<ResolveIndexItem.Builder, ObjectBuilder<ResolveIndexItem>> fn) {
            return this.indices(fn.apply(new ResolveIndexItem.Builder()).build());
        }

        public Builder addIndices(Function<ResolveIndexItem.Builder, ObjectBuilder<ResolveIndexItem>> fn) {
            return this.addIndices(fn.apply(new ResolveIndexItem.Builder()).build());
        }

        public Builder aliases(List<ResolveIndexAliasItem> value) {
            this.aliases = value;
            return this;
        }

        public Builder aliases(ResolveIndexAliasItem ... value) {
            this.aliases = Arrays.asList(value);
            return this;
        }

        public Builder addAliases(ResolveIndexAliasItem value) {
            if (this.aliases == null) {
                this.aliases = new ArrayList<ResolveIndexAliasItem>();
            }
            this.aliases.add(value);
            return this;
        }

        public Builder aliases(Function<ResolveIndexAliasItem.Builder, ObjectBuilder<ResolveIndexAliasItem>> fn) {
            return this.aliases(fn.apply(new ResolveIndexAliasItem.Builder()).build());
        }

        public Builder addAliases(Function<ResolveIndexAliasItem.Builder, ObjectBuilder<ResolveIndexAliasItem>> fn) {
            return this.addAliases(fn.apply(new ResolveIndexAliasItem.Builder()).build());
        }

        public Builder dataStreams(List<ResolveIndexDataStreamsItem> value) {
            this.dataStreams = value;
            return this;
        }

        public Builder dataStreams(ResolveIndexDataStreamsItem ... value) {
            this.dataStreams = Arrays.asList(value);
            return this;
        }

        public Builder addDataStreams(ResolveIndexDataStreamsItem value) {
            if (this.dataStreams == null) {
                this.dataStreams = new ArrayList<ResolveIndexDataStreamsItem>();
            }
            this.dataStreams.add(value);
            return this;
        }

        public Builder dataStreams(Function<ResolveIndexDataStreamsItem.Builder, ObjectBuilder<ResolveIndexDataStreamsItem>> fn) {
            return this.dataStreams(fn.apply(new ResolveIndexDataStreamsItem.Builder()).build());
        }

        public Builder addDataStreams(Function<ResolveIndexDataStreamsItem.Builder, ObjectBuilder<ResolveIndexDataStreamsItem>> fn) {
            return this.addDataStreams(fn.apply(new ResolveIndexDataStreamsItem.Builder()).build());
        }

        @Override
        public ResolveIndexResponse build() {
            return new ResolveIndexResponse(this);
        }
    }
}

