/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.analyze.AnalyzeDetail;
import co.elastic.clients.elasticsearch.indices.analyze.AnalyzeToken;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class AnalyzeResponse
implements JsonpSerializable {
    @Nullable
    private final AnalyzeDetail detail;
    @Nullable
    private final List<AnalyzeToken> tokens;
    public static final JsonpDeserializer<AnalyzeResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AnalyzeResponse::setupAnalyzeResponseDeserializer, Builder::build);

    public AnalyzeResponse(Builder builder) {
        this.detail = builder.detail;
        this.tokens = ModelTypeHelper.unmodifiable(builder.tokens);
    }

    public AnalyzeResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public AnalyzeDetail detail() {
        return this.detail;
    }

    @Nullable
    public List<AnalyzeToken> tokens() {
        return this.tokens;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.detail != null) {
            generator.writeKey("detail");
            this.detail.serialize(generator, mapper);
        }
        if (this.tokens != null) {
            generator.writeKey("tokens");
            generator.writeStartArray();
            for (AnalyzeToken item0 : this.tokens) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupAnalyzeResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::detail, AnalyzeDetail._DESERIALIZER, "detail", new String[0]);
        op.add(Builder::tokens, JsonpDeserializer.arrayDeserializer(AnalyzeToken._DESERIALIZER), "tokens", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<AnalyzeResponse> {
        @Nullable
        private AnalyzeDetail detail;
        @Nullable
        private List<AnalyzeToken> tokens;

        public Builder detail(@Nullable AnalyzeDetail value) {
            this.detail = value;
            return this;
        }

        public Builder detail(Function<AnalyzeDetail.Builder, ObjectBuilder<AnalyzeDetail>> fn) {
            return this.detail(fn.apply(new AnalyzeDetail.Builder()).build());
        }

        public Builder tokens(@Nullable List<AnalyzeToken> value) {
            this.tokens = value;
            return this;
        }

        public Builder tokens(AnalyzeToken ... value) {
            this.tokens = Arrays.asList(value);
            return this;
        }

        public Builder addTokens(AnalyzeToken value) {
            if (this.tokens == null) {
                this.tokens = new ArrayList<AnalyzeToken>();
            }
            this.tokens.add(value);
            return this;
        }

        public Builder tokens(Function<AnalyzeToken.Builder, ObjectBuilder<AnalyzeToken>> fn) {
            return this.tokens(fn.apply(new AnalyzeToken.Builder()).build());
        }

        public Builder addTokens(Function<AnalyzeToken.Builder, ObjectBuilder<AnalyzeToken>> fn) {
            return this.addTokens(fn.apply(new AnalyzeToken.Builder()).build());
        }

        @Override
        public AnalyzeResponse build() {
            return new AnalyzeResponse(this);
        }
    }
}

