/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ilm.ExplainLifecycleResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class ExplainLifecycleRequest
extends RequestBase {
    private final String index;
    @Nullable
    private final Boolean onlyErrors;
    @Nullable
    private final Boolean onlyManaged;
    public static final Endpoint<ExplainLifecycleRequest, ExplainLifecycleResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<ExplainLifecycleRequest, ExplainLifecycleResponse>(request -> "GET", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_ilm");
            buf.append("/explain");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.onlyErrors != null) {
            params.put("only_errors", String.valueOf(request.onlyErrors));
        }
        if (request.onlyManaged != null) {
            params.put("only_managed", String.valueOf(request.onlyManaged));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, ExplainLifecycleResponse._DESERIALIZER);

    public ExplainLifecycleRequest(Builder builder) {
        this.index = Objects.requireNonNull(builder.index, "index");
        this.onlyErrors = builder.onlyErrors;
        this.onlyManaged = builder.onlyManaged;
    }

    public ExplainLifecycleRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String index() {
        return this.index;
    }

    @Nullable
    public Boolean onlyErrors() {
        return this.onlyErrors;
    }

    @Nullable
    public Boolean onlyManaged() {
        return this.onlyManaged;
    }

    public static class Builder
    implements ObjectBuilder<ExplainLifecycleRequest> {
        private String index;
        @Nullable
        private Boolean onlyErrors;
        @Nullable
        private Boolean onlyManaged;

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder onlyErrors(@Nullable Boolean value) {
            this.onlyErrors = value;
            return this;
        }

        public Builder onlyManaged(@Nullable Boolean value) {
            this.onlyManaged = value;
            return this;
        }

        @Override
        public ExplainLifecycleRequest build() {
            return new ExplainLifecycleRequest(this);
        }
    }
}

