/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.graph;

import co.elastic.clients.elasticsearch.graph.VertexInclude;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class VertexDefinition
implements JsonpSerializable {
    @Nullable
    private final List<String> exclude;
    private final String field;
    @Nullable
    private final List<VertexInclude> include;
    @Nullable
    private final Long minDocCount;
    @Nullable
    private final Long shardMinDocCount;
    @Nullable
    private final Integer size;
    public static final JsonpDeserializer<VertexDefinition> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, VertexDefinition::setupVertexDefinitionDeserializer, Builder::build);

    public VertexDefinition(Builder builder) {
        this.exclude = ModelTypeHelper.unmodifiable(builder.exclude);
        this.field = Objects.requireNonNull(builder.field, "field");
        this.include = ModelTypeHelper.unmodifiable(builder.include);
        this.minDocCount = builder.minDocCount;
        this.shardMinDocCount = builder.shardMinDocCount;
        this.size = builder.size;
    }

    public VertexDefinition(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> exclude() {
        return this.exclude;
    }

    public String field() {
        return this.field;
    }

    @Nullable
    public List<VertexInclude> include() {
        return this.include;
    }

    @Nullable
    public Long minDocCount() {
        return this.minDocCount;
    }

    @Nullable
    public Long shardMinDocCount() {
        return this.shardMinDocCount;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.exclude != null) {
            generator.writeKey("exclude");
            generator.writeStartArray();
            for (String string : this.exclude) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        generator.writeKey("field");
        generator.write(this.field);
        if (this.include != null) {
            generator.writeKey("include");
            generator.writeStartArray();
            for (VertexInclude vertexInclude : this.include) {
                vertexInclude.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.minDocCount != null) {
            generator.writeKey("min_doc_count");
            generator.write(this.minDocCount.longValue());
        }
        if (this.shardMinDocCount != null) {
            generator.writeKey("shard_min_doc_count");
            generator.write(this.shardMinDocCount.longValue());
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
    }

    protected static void setupVertexDefinitionDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::exclude, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "exclude", new String[0]);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::include, JsonpDeserializer.arrayDeserializer(VertexInclude._DESERIALIZER), "include", new String[0]);
        op.add(Builder::minDocCount, JsonpDeserializer.longDeserializer(), "min_doc_count", new String[0]);
        op.add(Builder::shardMinDocCount, JsonpDeserializer.longDeserializer(), "shard_min_doc_count", new String[0]);
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<VertexDefinition> {
        @Nullable
        private List<String> exclude;
        private String field;
        @Nullable
        private List<VertexInclude> include;
        @Nullable
        private Long minDocCount;
        @Nullable
        private Long shardMinDocCount;
        @Nullable
        private Integer size;

        public Builder exclude(@Nullable List<String> value) {
            this.exclude = value;
            return this;
        }

        public Builder exclude(String ... value) {
            this.exclude = Arrays.asList(value);
            return this;
        }

        public Builder addExclude(String value) {
            if (this.exclude == null) {
                this.exclude = new ArrayList<String>();
            }
            this.exclude.add(value);
            return this;
        }

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder include(@Nullable List<VertexInclude> value) {
            this.include = value;
            return this;
        }

        public Builder include(VertexInclude ... value) {
            this.include = Arrays.asList(value);
            return this;
        }

        public Builder addInclude(VertexInclude value) {
            if (this.include == null) {
                this.include = new ArrayList<VertexInclude>();
            }
            this.include.add(value);
            return this;
        }

        public Builder include(Function<VertexInclude.Builder, ObjectBuilder<VertexInclude>> fn) {
            return this.include(fn.apply(new VertexInclude.Builder()).build());
        }

        public Builder addInclude(Function<VertexInclude.Builder, ObjectBuilder<VertexInclude>> fn) {
            return this.addInclude(fn.apply(new VertexInclude.Builder()).build());
        }

        public Builder minDocCount(@Nullable Long value) {
            this.minDocCount = value;
            return this;
        }

        public Builder shardMinDocCount(@Nullable Long value) {
            this.shardMinDocCount = value;
            return this;
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Override
        public VertexDefinition build() {
            return new VertexDefinition(this);
        }
    }
}

