/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.graph;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Vertex
implements JsonpSerializable {
    private final long depth;
    private final String field;
    private final String term;
    private final double weight;
    public static final JsonpDeserializer<Vertex> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Vertex::setupVertexDeserializer, Builder::build);

    public Vertex(Builder builder) {
        this.depth = Objects.requireNonNull(builder.depth, "depth");
        this.field = Objects.requireNonNull(builder.field, "field");
        this.term = Objects.requireNonNull(builder.term, "term");
        this.weight = Objects.requireNonNull(builder.weight, "weight");
    }

    public Vertex(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long depth() {
        return this.depth;
    }

    public String field() {
        return this.field;
    }

    public String term() {
        return this.term;
    }

    public double weight() {
        return this.weight;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("depth");
        generator.write(this.depth);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("term");
        generator.write(this.term);
        generator.writeKey("weight");
        generator.write(this.weight);
    }

    protected static void setupVertexDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::depth, JsonpDeserializer.longDeserializer(), "depth", new String[0]);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::term, JsonpDeserializer.stringDeserializer(), "term", new String[0]);
        op.add(Builder::weight, JsonpDeserializer.doubleDeserializer(), "weight", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Vertex> {
        private Long depth;
        private String field;
        private String term;
        private Double weight;

        public Builder depth(long value) {
            this.depth = value;
            return this;
        }

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder term(String value) {
            this.term = value;
            return this;
        }

        public Builder weight(double value) {
            this.weight = value;
            return this;
        }

        @Override
        public Vertex build() {
            return new Vertex(this);
        }
    }
}

