/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.graph;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class SampleDiversity
implements JsonpSerializable {
    private final String field;
    private final int maxDocsPerValue;
    public static final JsonpDeserializer<SampleDiversity> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SampleDiversity::setupSampleDiversityDeserializer, Builder::build);

    public SampleDiversity(Builder builder) {
        this.field = Objects.requireNonNull(builder.field, "field");
        this.maxDocsPerValue = Objects.requireNonNull(builder.maxDocsPerValue, "max_docs_per_value");
    }

    public SampleDiversity(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String field() {
        return this.field;
    }

    public int maxDocsPerValue() {
        return this.maxDocsPerValue;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("max_docs_per_value");
        generator.write(this.maxDocsPerValue);
    }

    protected static void setupSampleDiversityDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::maxDocsPerValue, JsonpDeserializer.integerDeserializer(), "max_docs_per_value", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SampleDiversity> {
        private String field;
        private Integer maxDocsPerValue;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder maxDocsPerValue(int value) {
            this.maxDocsPerValue = value;
            return this;
        }

        @Override
        public SampleDiversity build() {
            return new SampleDiversity(this);
        }
    }
}

