/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.eql;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GetStatusResponse
implements JsonpSerializable {
    private final String id;
    private final boolean isPartial;
    private final boolean isRunning;
    @Nullable
    private final String startTimeInMillis;
    @Nullable
    private final String expirationTimeInMillis;
    @Nullable
    private final Integer completionStatus;
    public static final JsonpDeserializer<GetStatusResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetStatusResponse::setupGetStatusResponseDeserializer, Builder::build);

    public GetStatusResponse(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.isPartial = Objects.requireNonNull(builder.isPartial, "is_partial");
        this.isRunning = Objects.requireNonNull(builder.isRunning, "is_running");
        this.startTimeInMillis = builder.startTimeInMillis;
        this.expirationTimeInMillis = builder.expirationTimeInMillis;
        this.completionStatus = builder.completionStatus;
    }

    public GetStatusResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    public boolean isPartial() {
        return this.isPartial;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    @Nullable
    public String startTimeInMillis() {
        return this.startTimeInMillis;
    }

    @Nullable
    public String expirationTimeInMillis() {
        return this.expirationTimeInMillis;
    }

    @Nullable
    public Integer completionStatus() {
        return this.completionStatus;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("is_partial");
        generator.write(this.isPartial);
        generator.writeKey("is_running");
        generator.write(this.isRunning);
        if (this.startTimeInMillis != null) {
            generator.writeKey("start_time_in_millis");
            generator.write(this.startTimeInMillis);
        }
        if (this.expirationTimeInMillis != null) {
            generator.writeKey("expiration_time_in_millis");
            generator.write(this.expirationTimeInMillis);
        }
        if (this.completionStatus != null) {
            generator.writeKey("completion_status");
            generator.write(this.completionStatus.intValue());
        }
    }

    protected static void setupGetStatusResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id", new String[0]);
        op.add(Builder::isPartial, JsonpDeserializer.booleanDeserializer(), "is_partial", new String[0]);
        op.add(Builder::isRunning, JsonpDeserializer.booleanDeserializer(), "is_running", new String[0]);
        op.add(Builder::startTimeInMillis, JsonpDeserializer.stringDeserializer(), "start_time_in_millis", new String[0]);
        op.add(Builder::expirationTimeInMillis, JsonpDeserializer.stringDeserializer(), "expiration_time_in_millis", new String[0]);
        op.add(Builder::completionStatus, JsonpDeserializer.integerDeserializer(), "completion_status", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetStatusResponse> {
        private String id;
        private Boolean isPartial;
        private Boolean isRunning;
        @Nullable
        private String startTimeInMillis;
        @Nullable
        private String expirationTimeInMillis;
        @Nullable
        private Integer completionStatus;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder isPartial(boolean value) {
            this.isPartial = value;
            return this;
        }

        public Builder isRunning(boolean value) {
            this.isRunning = value;
            return this;
        }

        public Builder startTimeInMillis(@Nullable String value) {
            this.startTimeInMillis = value;
            return this;
        }

        public Builder expirationTimeInMillis(@Nullable String value) {
            this.expirationTimeInMillis = value;
            return this;
        }

        public Builder completionStatus(@Nullable Integer value) {
            this.completionStatus = value;
            return this;
        }

        @Override
        public GetStatusResponse build() {
            return new GetStatusResponse(this);
        }
    }
}

