/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.enrich.stats;

import co.elastic.clients.elasticsearch.tasks.Info;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ExecutingPolicy
implements JsonpSerializable {
    private final String name;
    private final Info task;
    public static final JsonpDeserializer<ExecutingPolicy> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExecutingPolicy::setupExecutingPolicyDeserializer, Builder::build);

    public ExecutingPolicy(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.task = Objects.requireNonNull(builder.task, "task");
    }

    public ExecutingPolicy(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    public Info task() {
        return this.task;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("task");
        this.task.serialize(generator, mapper);
    }

    protected static void setupExecutingPolicyDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::task, Info._DESERIALIZER, "task", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ExecutingPolicy> {
        private String name;
        private Info task;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder task(Info value) {
            this.task = value;
            return this;
        }

        public Builder task(Function<Info.Builder, ObjectBuilder<Info>> fn) {
            return this.task(fn.apply(new Info.Builder()).build());
        }

        @Override
        public ExecutingPolicy build() {
            return new ExecutingPolicy(this);
        }
    }
}

