/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class OperatingSystemMemoryInfo
implements JsonpSerializable {
    private final long freeInBytes;
    private final int freePercent;
    private final long totalInBytes;
    private final long usedInBytes;
    private final int usedPercent;
    public static final JsonpDeserializer<OperatingSystemMemoryInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OperatingSystemMemoryInfo::setupOperatingSystemMemoryInfoDeserializer, Builder::build);

    public OperatingSystemMemoryInfo(Builder builder) {
        this.freeInBytes = Objects.requireNonNull(builder.freeInBytes, "free_in_bytes");
        this.freePercent = Objects.requireNonNull(builder.freePercent, "free_percent");
        this.totalInBytes = Objects.requireNonNull(builder.totalInBytes, "total_in_bytes");
        this.usedInBytes = Objects.requireNonNull(builder.usedInBytes, "used_in_bytes");
        this.usedPercent = Objects.requireNonNull(builder.usedPercent, "used_percent");
    }

    public OperatingSystemMemoryInfo(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long freeInBytes() {
        return this.freeInBytes;
    }

    public int freePercent() {
        return this.freePercent;
    }

    public long totalInBytes() {
        return this.totalInBytes;
    }

    public long usedInBytes() {
        return this.usedInBytes;
    }

    public int usedPercent() {
        return this.usedPercent;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("free_in_bytes");
        generator.write(this.freeInBytes);
        generator.writeKey("free_percent");
        generator.write(this.freePercent);
        generator.writeKey("total_in_bytes");
        generator.write(this.totalInBytes);
        generator.writeKey("used_in_bytes");
        generator.write(this.usedInBytes);
        generator.writeKey("used_percent");
        generator.write(this.usedPercent);
    }

    protected static void setupOperatingSystemMemoryInfoDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::freeInBytes, JsonpDeserializer.longDeserializer(), "free_in_bytes", new String[0]);
        op.add(Builder::freePercent, JsonpDeserializer.integerDeserializer(), "free_percent", new String[0]);
        op.add(Builder::totalInBytes, JsonpDeserializer.longDeserializer(), "total_in_bytes", new String[0]);
        op.add(Builder::usedInBytes, JsonpDeserializer.longDeserializer(), "used_in_bytes", new String[0]);
        op.add(Builder::usedPercent, JsonpDeserializer.integerDeserializer(), "used_percent", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<OperatingSystemMemoryInfo> {
        private Long freeInBytes;
        private Integer freePercent;
        private Long totalInBytes;
        private Long usedInBytes;
        private Integer usedPercent;

        public Builder freeInBytes(long value) {
            this.freeInBytes = value;
            return this;
        }

        public Builder freePercent(int value) {
            this.freePercent = value;
            return this;
        }

        public Builder totalInBytes(long value) {
            this.totalInBytes = value;
            return this;
        }

        public Builder usedInBytes(long value) {
            this.usedInBytes = value;
            return this;
        }

        public Builder usedPercent(int value) {
            this.usedPercent = value;
            return this;
        }

        @Override
        public OperatingSystemMemoryInfo build() {
            return new OperatingSystemMemoryInfo(this);
        }
    }
}

