/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.elasticsearch.cluster.stats.ClusterProcessCpu;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterProcessOpenFileDescriptors;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ClusterProcess
implements JsonpSerializable {
    private final ClusterProcessCpu cpu;
    private final ClusterProcessOpenFileDescriptors openFileDescriptors;
    public static final JsonpDeserializer<ClusterProcess> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterProcess::setupClusterProcessDeserializer, Builder::build);

    public ClusterProcess(Builder builder) {
        this.cpu = Objects.requireNonNull(builder.cpu, "cpu");
        this.openFileDescriptors = Objects.requireNonNull(builder.openFileDescriptors, "open_file_descriptors");
    }

    public ClusterProcess(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public ClusterProcessCpu cpu() {
        return this.cpu;
    }

    public ClusterProcessOpenFileDescriptors openFileDescriptors() {
        return this.openFileDescriptors;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cpu");
        this.cpu.serialize(generator, mapper);
        generator.writeKey("open_file_descriptors");
        this.openFileDescriptors.serialize(generator, mapper);
    }

    protected static void setupClusterProcessDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::cpu, ClusterProcessCpu._DESERIALIZER, "cpu", new String[0]);
        op.add(Builder::openFileDescriptors, ClusterProcessOpenFileDescriptors._DESERIALIZER, "open_file_descriptors", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ClusterProcess> {
        private ClusterProcessCpu cpu;
        private ClusterProcessOpenFileDescriptors openFileDescriptors;

        public Builder cpu(ClusterProcessCpu value) {
            this.cpu = value;
            return this;
        }

        public Builder cpu(Function<ClusterProcessCpu.Builder, ObjectBuilder<ClusterProcessCpu>> fn) {
            return this.cpu(fn.apply(new ClusterProcessCpu.Builder()).build());
        }

        public Builder openFileDescriptors(ClusterProcessOpenFileDescriptors value) {
            this.openFileDescriptors = value;
            return this;
        }

        public Builder openFileDescriptors(Function<ClusterProcessOpenFileDescriptors.Builder, ObjectBuilder<ClusterProcessOpenFileDescriptors>> fn) {
            return this.openFileDescriptors(fn.apply(new ClusterProcessOpenFileDescriptors.Builder()).build());
        }

        @Override
        public ClusterProcess build() {
            return new ClusterProcess(this);
        }
    }
}

