/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.allocation_explain;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ReservedSize
implements JsonpSerializable {
    private final String nodeId;
    private final String path;
    private final long total;
    private final List<String> shards;
    public static final JsonpDeserializer<ReservedSize> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReservedSize::setupReservedSizeDeserializer, Builder::build);

    public ReservedSize(Builder builder) {
        this.nodeId = Objects.requireNonNull(builder.nodeId, "node_id");
        this.path = Objects.requireNonNull(builder.path, "path");
        this.total = Objects.requireNonNull(builder.total, "total");
        this.shards = ModelTypeHelper.unmodifiableNonNull(builder.shards, "shards");
    }

    public ReservedSize(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String nodeId() {
        return this.nodeId;
    }

    public String path() {
        return this.path;
    }

    public long total() {
        return this.total;
    }

    public List<String> shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("node_id");
        generator.write(this.nodeId);
        generator.writeKey("path");
        generator.write(this.path);
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("shards");
        generator.writeStartArray();
        for (String item0 : this.shards) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static void setupReservedSizeDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node_id", new String[0]);
        op.add(Builder::path, JsonpDeserializer.stringDeserializer(), "path", new String[0]);
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total", new String[0]);
        op.add(Builder::shards, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "shards", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ReservedSize> {
        private String nodeId;
        private String path;
        private Long total;
        private List<String> shards;

        public Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        public Builder path(String value) {
            this.path = value;
            return this;
        }

        public Builder total(long value) {
            this.total = value;
            return this;
        }

        public Builder shards(List<String> value) {
            this.shards = value;
            return this;
        }

        public Builder shards(String ... value) {
            this.shards = Arrays.asList(value);
            return this;
        }

        public Builder addShards(String value) {
            if (this.shards == null) {
                this.shards = new ArrayList<String>();
            }
            this.shards.add(value);
            return this;
        }

        @Override
        public ReservedSize build() {
            return new ReservedSize(this);
        }
    }
}

