/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.allocation_explain;

import co.elastic.clients.elasticsearch.cluster.allocation_explain.AllocationDecision;
import co.elastic.clients.elasticsearch.cluster.allocation_explain.AllocationStore;
import co.elastic.clients.elasticsearch.cluster.allocation_explain.Decision;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class NodeAllocationExplanation
implements JsonpSerializable {
    private final List<AllocationDecision> deciders;
    private final Map<String, String> nodeAttributes;
    private final Decision nodeDecision;
    private final String nodeId;
    private final String nodeName;
    @Nullable
    private final AllocationStore store;
    private final String transportAddress;
    private final int weightRanking;
    public static final JsonpDeserializer<NodeAllocationExplanation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeAllocationExplanation::setupNodeAllocationExplanationDeserializer, Builder::build);

    public NodeAllocationExplanation(Builder builder) {
        this.deciders = ModelTypeHelper.unmodifiableNonNull(builder.deciders, "deciders");
        this.nodeAttributes = ModelTypeHelper.unmodifiableNonNull(builder.nodeAttributes, "node_attributes");
        this.nodeDecision = Objects.requireNonNull(builder.nodeDecision, "node_decision");
        this.nodeId = Objects.requireNonNull(builder.nodeId, "node_id");
        this.nodeName = Objects.requireNonNull(builder.nodeName, "node_name");
        this.store = builder.store;
        this.transportAddress = Objects.requireNonNull(builder.transportAddress, "transport_address");
        this.weightRanking = Objects.requireNonNull(builder.weightRanking, "weight_ranking");
    }

    public NodeAllocationExplanation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<AllocationDecision> deciders() {
        return this.deciders;
    }

    public Map<String, String> nodeAttributes() {
        return this.nodeAttributes;
    }

    public Decision nodeDecision() {
        return this.nodeDecision;
    }

    public String nodeId() {
        return this.nodeId;
    }

    public String nodeName() {
        return this.nodeName;
    }

    @Nullable
    public AllocationStore store() {
        return this.store;
    }

    public String transportAddress() {
        return this.transportAddress;
    }

    public int weightRanking() {
        return this.weightRanking;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("deciders");
        generator.writeStartArray();
        for (AllocationDecision allocationDecision : this.deciders) {
            allocationDecision.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("node_attributes");
        generator.writeStartObject();
        for (Map.Entry entry : this.nodeAttributes.entrySet()) {
            generator.writeKey((String)entry.getKey());
            generator.write((String)entry.getValue());
        }
        generator.writeEnd();
        generator.writeKey("node_decision");
        this.nodeDecision.serialize(generator, mapper);
        generator.writeKey("node_id");
        generator.write(this.nodeId);
        generator.writeKey("node_name");
        generator.write(this.nodeName);
        if (this.store != null) {
            generator.writeKey("store");
            this.store.serialize(generator, mapper);
        }
        generator.writeKey("transport_address");
        generator.write(this.transportAddress);
        generator.writeKey("weight_ranking");
        generator.write(this.weightRanking);
    }

    protected static void setupNodeAllocationExplanationDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::deciders, JsonpDeserializer.arrayDeserializer(AllocationDecision._DESERIALIZER), "deciders", new String[0]);
        op.add(Builder::nodeAttributes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "node_attributes", new String[0]);
        op.add(Builder::nodeDecision, Decision._DESERIALIZER, "node_decision", new String[0]);
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node_id", new String[0]);
        op.add(Builder::nodeName, JsonpDeserializer.stringDeserializer(), "node_name", new String[0]);
        op.add(Builder::store, AllocationStore._DESERIALIZER, "store", new String[0]);
        op.add(Builder::transportAddress, JsonpDeserializer.stringDeserializer(), "transport_address", new String[0]);
        op.add(Builder::weightRanking, JsonpDeserializer.integerDeserializer(), "weight_ranking", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NodeAllocationExplanation> {
        private List<AllocationDecision> deciders;
        private Map<String, String> nodeAttributes;
        private Decision nodeDecision;
        private String nodeId;
        private String nodeName;
        @Nullable
        private AllocationStore store;
        private String transportAddress;
        private Integer weightRanking;

        public Builder deciders(List<AllocationDecision> value) {
            this.deciders = value;
            return this;
        }

        public Builder deciders(AllocationDecision ... value) {
            this.deciders = Arrays.asList(value);
            return this;
        }

        public Builder addDeciders(AllocationDecision value) {
            if (this.deciders == null) {
                this.deciders = new ArrayList<AllocationDecision>();
            }
            this.deciders.add(value);
            return this;
        }

        public Builder deciders(Function<AllocationDecision.Builder, ObjectBuilder<AllocationDecision>> fn) {
            return this.deciders(fn.apply(new AllocationDecision.Builder()).build());
        }

        public Builder addDeciders(Function<AllocationDecision.Builder, ObjectBuilder<AllocationDecision>> fn) {
            return this.addDeciders(fn.apply(new AllocationDecision.Builder()).build());
        }

        public Builder nodeAttributes(Map<String, String> value) {
            this.nodeAttributes = value;
            return this;
        }

        public Builder putNodeAttributes(String key, String value) {
            if (this.nodeAttributes == null) {
                this.nodeAttributes = new HashMap<String, String>();
            }
            this.nodeAttributes.put(key, value);
            return this;
        }

        public Builder nodeDecision(Decision value) {
            this.nodeDecision = value;
            return this;
        }

        public Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        public Builder nodeName(String value) {
            this.nodeName = value;
            return this;
        }

        public Builder store(@Nullable AllocationStore value) {
            this.store = value;
            return this;
        }

        public Builder store(Function<AllocationStore.Builder, ObjectBuilder<AllocationStore>> fn) {
            return this.store(fn.apply(new AllocationStore.Builder()).build());
        }

        public Builder transportAddress(String value) {
            this.transportAddress = value;
            return this;
        }

        public Builder weightRanking(int value) {
            this.weightRanking = value;
            return this;
        }

        @Override
        public NodeAllocationExplanation build() {
            return new NodeAllocationExplanation(this);
        }
    }
}

