/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch.cluster.PutComponentTemplateResponse;
import co.elastic.clients.elasticsearch.indices.AliasDefinition;
import co.elastic.clients.elasticsearch.indices.IndexSettings;
import co.elastic.clients.elasticsearch.indices.IndexState;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PutComponentTemplateRequest
extends RequestBase
implements JsonpSerializable {
    private final String name;
    @Nullable
    private final Boolean create;
    @Nullable
    private final String masterTimeout;
    private final IndexState template;
    @Nullable
    private final Map<String, AliasDefinition> aliases;
    @Nullable
    private final TypeMapping mappings;
    @Nullable
    private final IndexSettings settings;
    @Nullable
    private final Long version;
    @Nullable
    private final Map<String, JsonData> meta;
    public static final JsonpDeserializer<PutComponentTemplateRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutComponentTemplateRequest::setupPutComponentTemplateRequestDeserializer, Builder::build);
    public static final Endpoint<PutComponentTemplateRequest, PutComponentTemplateResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PutComponentTemplateRequest, PutComponentTemplateResponse>(request -> "PUT", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_component_template");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.create != null) {
            params.put("create", String.valueOf(request.create));
        }
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutComponentTemplateResponse._DESERIALIZER);

    public PutComponentTemplateRequest(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.create = builder.create;
        this.masterTimeout = builder.masterTimeout;
        this.template = Objects.requireNonNull(builder.template, "template");
        this.aliases = ModelTypeHelper.unmodifiable(builder.aliases);
        this.mappings = builder.mappings;
        this.settings = builder.settings;
        this.version = builder.version;
        this.meta = ModelTypeHelper.unmodifiable(builder.meta);
    }

    public PutComponentTemplateRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public Boolean create() {
        return this.create;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    public IndexState template() {
        return this.template;
    }

    @Nullable
    public Map<String, AliasDefinition> aliases() {
        return this.aliases;
    }

    @Nullable
    public TypeMapping mappings() {
        return this.mappings;
    }

    @Nullable
    public IndexSettings settings() {
        return this.settings;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Nullable
    public Map<String, JsonData> meta() {
        return this.meta;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("template");
        this.template.serialize(generator, mapper);
        if (this.aliases != null) {
            generator.writeKey("aliases");
            generator.writeStartObject();
            for (Map.Entry<String, AliasDefinition> entry : this.aliases.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.mappings != null) {
            generator.writeKey("mappings");
            this.mappings.serialize(generator, mapper);
        }
        if (this.settings != null) {
            generator.writeKey("settings");
            this.settings.serialize(generator, mapper);
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
        if (this.meta != null) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.meta.entrySet()) {
                generator.writeKey(entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupPutComponentTemplateRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::template, IndexState._DESERIALIZER, "template", new String[0]);
        op.add(Builder::aliases, JsonpDeserializer.stringMapDeserializer(AliasDefinition._DESERIALIZER), "aliases", new String[0]);
        op.add(Builder::mappings, TypeMapping._DESERIALIZER, "mappings", new String[0]);
        op.add(Builder::settings, IndexSettings._DESERIALIZER, "settings", new String[0]);
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version", new String[0]);
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PutComponentTemplateRequest> {
        private String name;
        @Nullable
        private Boolean create;
        @Nullable
        private String masterTimeout;
        private IndexState template;
        @Nullable
        private Map<String, AliasDefinition> aliases;
        @Nullable
        private TypeMapping mappings;
        @Nullable
        private IndexSettings settings;
        @Nullable
        private Long version;
        @Nullable
        private Map<String, JsonData> meta;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder create(@Nullable Boolean value) {
            this.create = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder template(IndexState value) {
            this.template = value;
            return this;
        }

        public Builder template(Function<IndexState.Builder, ObjectBuilder<IndexState>> fn) {
            return this.template(fn.apply(new IndexState.Builder()).build());
        }

        public Builder aliases(@Nullable Map<String, AliasDefinition> value) {
            this.aliases = value;
            return this;
        }

        public Builder putAliases(String key, AliasDefinition value) {
            if (this.aliases == null) {
                this.aliases = new HashMap<String, AliasDefinition>();
            }
            this.aliases.put(key, value);
            return this;
        }

        public Builder aliases(String key, Function<AliasDefinition.Builder, ObjectBuilder<AliasDefinition>> fn) {
            return this.aliases(Collections.singletonMap(key, fn.apply(new AliasDefinition.Builder()).build()));
        }

        public Builder putAliases(String key, Function<AliasDefinition.Builder, ObjectBuilder<AliasDefinition>> fn) {
            return this.putAliases(key, fn.apply(new AliasDefinition.Builder()).build());
        }

        public Builder mappings(@Nullable TypeMapping value) {
            this.mappings = value;
            return this;
        }

        public Builder mappings(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.mappings(fn.apply(new TypeMapping.Builder()).build());
        }

        public Builder settings(@Nullable IndexSettings value) {
            this.settings = value;
            return this;
        }

        public Builder settings(Function<IndexSettings.Builder, ObjectBuilder<IndexSettings>> fn) {
            return this.settings(fn.apply(new IndexSettings.Builder()).build());
        }

        public Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public Builder meta(@Nullable Map<String, JsonData> value) {
            this.meta = value;
            return this;
        }

        public Builder putMeta(String key, JsonData value) {
            if (this.meta == null) {
                this.meta = new HashMap<String, JsonData>();
            }
            this.meta.put(key, value);
            return this;
        }

        @Override
        public PutComponentTemplateRequest build() {
            return new PutComponentTemplateRequest(this);
        }
    }
}

