/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.cluster.GetSettingsResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class GetSettingsRequest
extends RequestBase {
    @Nullable
    private final Boolean flatSettings;
    @Nullable
    private final Boolean includeDefaults;
    @Nullable
    private final String masterTimeout;
    @Nullable
    private final String timeout;
    public static final Endpoint<GetSettingsRequest, GetSettingsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetSettingsRequest, GetSettingsResponse>(request -> "GET", request -> "/_cluster/settings", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.flatSettings != null) {
            params.put("flat_settings", String.valueOf(request.flatSettings));
        }
        if (request.includeDefaults != null) {
            params.put("include_defaults", String.valueOf(request.includeDefaults));
        }
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetSettingsResponse._DESERIALIZER);

    public GetSettingsRequest(Builder builder) {
        this.flatSettings = builder.flatSettings;
        this.includeDefaults = builder.includeDefaults;
        this.masterTimeout = builder.masterTimeout;
        this.timeout = builder.timeout;
    }

    public GetSettingsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Boolean flatSettings() {
        return this.flatSettings;
    }

    @Nullable
    public Boolean includeDefaults() {
        return this.includeDefaults;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    public static class Builder
    implements ObjectBuilder<GetSettingsRequest> {
        @Nullable
        private Boolean flatSettings;
        @Nullable
        private Boolean includeDefaults;
        @Nullable
        private String masterTimeout;
        @Nullable
        private String timeout;

        public Builder flatSettings(@Nullable Boolean value) {
            this.flatSettings = value;
            return this;
        }

        public Builder includeDefaults(@Nullable Boolean value) {
            this.includeDefaults = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        @Override
        public GetSettingsRequest build() {
            return new GetSettingsRequest(this);
        }
    }
}

