/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch.cat.count.CountRecord;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class CountResponse
implements JsonpSerializable {
    private final List<CountRecord> valueBody;
    public static final JsonpDeserializer<CountResponse> _DESERIALIZER = CountResponse.createCountResponseDeserializer();

    public CountResponse(Builder builder) {
        this.valueBody = ModelTypeHelper.unmodifiableNonNull(builder.valueBody, "_value_body");
    }

    public CountResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<CountRecord> valueBody() {
        return this.valueBody;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartArray();
        for (CountRecord item0 : this.valueBody) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static JsonpDeserializer<CountResponse> createCountResponseDeserializer() {
        JsonpDeserializer<List<CountRecord>> valueDeserializer = JsonpDeserializer.arrayDeserializer(CountRecord._DESERIALIZER);
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().valueBody((List)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    implements ObjectBuilder<CountResponse> {
        private List<CountRecord> valueBody;

        public Builder valueBody(List<CountRecord> value) {
            this.valueBody = value;
            return this;
        }

        public Builder valueBody(CountRecord ... value) {
            this.valueBody = Arrays.asList(value);
            return this;
        }

        public Builder addValueBody(CountRecord value) {
            if (this.valueBody == null) {
                this.valueBody = new ArrayList<CountRecord>();
            }
            this.valueBody.add(value);
            return this;
        }

        public Builder valueBody(Function<CountRecord.Builder, ObjectBuilder<CountRecord>> fn) {
            return this.valueBody(fn.apply(new CountRecord.Builder()).build());
        }

        public Builder addValueBody(Function<CountRecord.Builder, ObjectBuilder<CountRecord>> fn) {
            return this.addValueBody(fn.apply(new CountRecord.Builder()).build());
        }

        @Override
        public CountResponse build() {
            return new CountResponse(this);
        }
    }
}

