/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.autoscaling;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.autoscaling.AutoscalingPolicy;
import co.elastic.clients.elasticsearch.autoscaling.PutAutoscalingPolicyResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class PutAutoscalingPolicyRequest
extends RequestBase
implements JsonpSerializable {
    private final String name;
    private final AutoscalingPolicy policy;
    public static final JsonpDeserializer<PutAutoscalingPolicyRequest> _DESERIALIZER = PutAutoscalingPolicyRequest.createPutAutoscalingPolicyRequestDeserializer();
    public static final Endpoint<PutAutoscalingPolicyRequest, PutAutoscalingPolicyResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PutAutoscalingPolicyRequest, PutAutoscalingPolicyResponse>(request -> "PUT", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_autoscaling");
            buf.append("/policy");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutAutoscalingPolicyResponse._DESERIALIZER);

    public PutAutoscalingPolicyRequest(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.policy = Objects.requireNonNull(builder.policy, "_value_body");
    }

    public PutAutoscalingPolicyRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    public AutoscalingPolicy policy() {
        return this.policy;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this.policy.serialize(generator, mapper);
    }

    protected static JsonpDeserializer<PutAutoscalingPolicyRequest> createPutAutoscalingPolicyRequestDeserializer() {
        JsonpDeserializer<AutoscalingPolicy> valueDeserializer = AutoscalingPolicy._DESERIALIZER;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().policy((AutoscalingPolicy)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    implements ObjectBuilder<PutAutoscalingPolicyRequest> {
        private String name;
        private AutoscalingPolicy policy;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder policy(AutoscalingPolicy value) {
            this.policy = value;
            return this;
        }

        public Builder policy(Function<AutoscalingPolicy.Builder, ObjectBuilder<AutoscalingPolicy>> fn) {
            return this.policy(fn.apply(new AutoscalingPolicy.Builder()).build());
        }

        @Override
        public PutAutoscalingPolicyRequest build() {
            return new PutAutoscalingPolicyRequest(this);
        }
    }
}

