/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.async_search;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.async_search.GetResponse;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class GetRequest
extends RequestBase {
    private final String id;
    @Nullable
    private final String keepAlive;
    @Nullable
    private final Boolean typedKeys;
    @Nullable
    private final String waitForCompletionTimeout;
    private static final SimpleEndpoint<GetRequest, Void> ENDPOINT = new SimpleEndpoint(request -> "GET", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_async_search");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.keepAlive != null) {
            params.put("keep_alive", request.keepAlive);
        }
        if (request.typedKeys != null) {
            params.put("typed_keys", String.valueOf(request.typedKeys));
        }
        if (request.waitForCompletionTimeout != null) {
            params.put("wait_for_completion_timeout", request.waitForCompletionTimeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, null);

    public GetRequest(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.keepAlive = builder.keepAlive;
        this.typedKeys = builder.typedKeys;
        this.waitForCompletionTimeout = builder.waitForCompletionTimeout;
    }

    public GetRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public String keepAlive() {
        return this.keepAlive;
    }

    @Nullable
    public Boolean typedKeys() {
        return this.typedKeys;
    }

    @Nullable
    public String waitForCompletionTimeout() {
        return this.waitForCompletionTimeout;
    }

    public static <TDocument> Endpoint<GetRequest, GetResponse<TDocument>, ElasticsearchError> createGetEndpoint(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ENDPOINT.withResponseDeserializer(GetResponse.createGetResponseDeserializer(tDocumentDeserializer));
    }

    public static class Builder
    implements ObjectBuilder<GetRequest> {
        private String id;
        @Nullable
        private String keepAlive;
        @Nullable
        private Boolean typedKeys;
        @Nullable
        private String waitForCompletionTimeout;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder keepAlive(@Nullable String value) {
            this.keepAlive = value;
            return this;
        }

        public Builder typedKeys(@Nullable Boolean value) {
            this.typedKeys = value;
            return this;
        }

        public Builder waitForCompletionTimeout(@Nullable String value) {
            this.waitForCompletionTimeout = value;
            return this;
        }

        @Override
        public GetRequest build() {
            return new GetRequest(this);
        }
    }
}

