/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanQueryVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SpanNearQuery
extends QueryBase
implements SpanQueryVariant,
QueryVariant {
    private final List<SpanQuery> clauses;
    @Nullable
    private final Boolean inOrder;
    @Nullable
    private final Integer slop;
    public static final JsonpDeserializer<SpanNearQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SpanNearQuery::setupSpanNearQueryDeserializer, Builder::build);

    public SpanNearQuery(Builder builder) {
        super(builder);
        this.clauses = ModelTypeHelper.unmodifiableNonNull(builder.clauses, "clauses");
        this.inOrder = builder.inOrder;
        this.slop = builder.slop;
    }

    public SpanNearQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "span_near";
    }

    public List<SpanQuery> clauses() {
        return this.clauses;
    }

    @Nullable
    public Boolean inOrder() {
        return this.inOrder;
    }

    @Nullable
    public Integer slop() {
        return this.slop;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("clauses");
        generator.writeStartArray();
        for (SpanQuery item0 : this.clauses) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.inOrder != null) {
            generator.writeKey("in_order");
            generator.write(this.inOrder.booleanValue());
        }
        if (this.slop != null) {
            generator.writeKey("slop");
            generator.write(this.slop.intValue());
        }
    }

    protected static void setupSpanNearQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::clauses, JsonpDeserializer.arrayDeserializer(SpanQuery._DESERIALIZER), "clauses", new String[0]);
        op.add(Builder::inOrder, JsonpDeserializer.booleanDeserializer(), "in_order", new String[0]);
        op.add(Builder::slop, JsonpDeserializer.integerDeserializer(), "slop", new String[0]);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SpanNearQuery> {
        private List<SpanQuery> clauses;
        @Nullable
        private Boolean inOrder;
        @Nullable
        private Integer slop;

        public Builder clauses(List<SpanQuery> value) {
            this.clauses = value;
            return this;
        }

        public Builder clauses(SpanQuery ... value) {
            this.clauses = Arrays.asList(value);
            return this;
        }

        public Builder addClauses(SpanQuery value) {
            if (this.clauses == null) {
                this.clauses = new ArrayList<SpanQuery>();
            }
            this.clauses.add(value);
            return this;
        }

        public Builder clauses(Function<SpanQuery.Builder, ObjectBuilder<SpanQuery>> fn) {
            return this.clauses(fn.apply(new SpanQuery.Builder()).build());
        }

        public Builder addClauses(Function<SpanQuery.Builder, ObjectBuilder<SpanQuery>> fn) {
            return this.addClauses(fn.apply(new SpanQuery.Builder()).build());
        }

        public Builder inOrder(@Nullable Boolean value) {
            this.inOrder = value;
            return this;
        }

        public Builder slop(@Nullable Integer value) {
            this.slop = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SpanNearQuery build() {
            return new SpanNearQuery(this);
        }
    }
}

