/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanQueryVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class SpanFieldMaskingQuery
extends QueryBase
implements SpanQueryVariant,
QueryVariant {
    private final String field;
    private final SpanQuery query;
    public static final JsonpDeserializer<SpanFieldMaskingQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SpanFieldMaskingQuery::setupSpanFieldMaskingQueryDeserializer, Builder::build);

    public SpanFieldMaskingQuery(Builder builder) {
        super(builder);
        this.field = Objects.requireNonNull(builder.field, "field");
        this.query = Objects.requireNonNull(builder.query, "query");
    }

    public SpanFieldMaskingQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "field_masking_span";
    }

    public String field() {
        return this.field;
    }

    public SpanQuery query() {
        return this.query;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("query");
        this.query.serialize(generator, mapper);
    }

    protected static void setupSpanFieldMaskingQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::query, SpanQuery._DESERIALIZER, "query", new String[0]);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SpanFieldMaskingQuery> {
        private String field;
        private SpanQuery query;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder query(SpanQuery value) {
            this.query = value;
            return this;
        }

        public Builder query(Function<SpanQuery.Builder, ObjectBuilder<SpanQuery>> fn) {
            return this.query(fn.apply(new SpanQuery.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SpanFieldMaskingQuery build() {
            return new SpanFieldMaskingQuery(this);
        }
    }
}

