/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.ShapeRelation;
import co.elastic.clients.elasticsearch._types.query_dsl.FieldLookup;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ShapeFieldQuery
implements JsonpSerializable {
    @Nullable
    private final Boolean ignoreUnmapped;
    @Nullable
    private final FieldLookup indexedShape;
    @Nullable
    private final ShapeRelation relation;
    @Nullable
    private final JsonData shape;
    public static final JsonpDeserializer<ShapeFieldQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShapeFieldQuery::setupShapeFieldQueryDeserializer, Builder::build);

    public ShapeFieldQuery(Builder builder) {
        this.ignoreUnmapped = builder.ignoreUnmapped;
        this.indexedShape = builder.indexedShape;
        this.relation = builder.relation;
        this.shape = builder.shape;
    }

    public ShapeFieldQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Nullable
    public FieldLookup indexedShape() {
        return this.indexedShape;
    }

    @Nullable
    public ShapeRelation relation() {
        return this.relation;
    }

    @Nullable
    public JsonData shape() {
        return this.shape;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.ignoreUnmapped != null) {
            generator.writeKey("ignore_unmapped");
            generator.write(this.ignoreUnmapped.booleanValue());
        }
        if (this.indexedShape != null) {
            generator.writeKey("indexed_shape");
            this.indexedShape.serialize(generator, mapper);
        }
        if (this.relation != null) {
            generator.writeKey("relation");
            this.relation.serialize(generator, mapper);
        }
        if (this.shape != null) {
            generator.writeKey("shape");
            this.shape.serialize(generator, mapper);
        }
    }

    protected static void setupShapeFieldQueryDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::ignoreUnmapped, JsonpDeserializer.booleanDeserializer(), "ignore_unmapped", new String[0]);
        op.add(Builder::indexedShape, FieldLookup._DESERIALIZER, "indexed_shape", new String[0]);
        op.add(Builder::relation, ShapeRelation._DESERIALIZER, "relation", new String[0]);
        op.add(Builder::shape, JsonData._DESERIALIZER, "shape", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ShapeFieldQuery> {
        @Nullable
        private Boolean ignoreUnmapped;
        @Nullable
        private FieldLookup indexedShape;
        @Nullable
        private ShapeRelation relation;
        @Nullable
        private JsonData shape;

        public Builder ignoreUnmapped(@Nullable Boolean value) {
            this.ignoreUnmapped = value;
            return this;
        }

        public Builder indexedShape(@Nullable FieldLookup value) {
            this.indexedShape = value;
            return this;
        }

        public Builder indexedShape(Function<FieldLookup.Builder, ObjectBuilder<FieldLookup>> fn) {
            return this.indexedShape(fn.apply(new FieldLookup.Builder()).build());
        }

        public Builder relation(@Nullable ShapeRelation value) {
            this.relation = value;
            return this;
        }

        public Builder shape(@Nullable JsonData value) {
            this.shape = value;
            return this;
        }

        @Override
        public ShapeFieldQuery build() {
            return new ShapeFieldQuery(this);
        }
    }
}

