/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.RankFeatureFunction;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class RankFeatureFunctionLogarithm
extends RankFeatureFunction
implements JsonpSerializable {
    private final float scalingFactor;
    public static final JsonpDeserializer<RankFeatureFunctionLogarithm> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RankFeatureFunctionLogarithm::setupRankFeatureFunctionLogarithmDeserializer, Builder::build);

    public RankFeatureFunctionLogarithm(Builder builder) {
        this.scalingFactor = Objects.requireNonNull(builder.scalingFactor, "scaling_factor").floatValue();
    }

    public RankFeatureFunctionLogarithm(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public float scalingFactor() {
        return this.scalingFactor;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("scaling_factor");
        generator.write((double)this.scalingFactor);
    }

    protected static void setupRankFeatureFunctionLogarithmDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::scalingFactor, JsonpDeserializer.floatDeserializer(), "scaling_factor", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RankFeatureFunctionLogarithm> {
        private Float scalingFactor;

        public Builder scalingFactor(float value) {
            this.scalingFactor = Float.valueOf(value);
            return this;
        }

        @Override
        public RankFeatureFunctionLogarithm build() {
            return new RankFeatureFunctionLogarithm(this);
        }
    }
}

