/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Operator;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.TextQueryType;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class QueryStringQuery
extends QueryBase
implements QueryVariant {
    @Nullable
    private final Boolean allowLeadingWildcard;
    @Nullable
    private final String analyzer;
    @Nullable
    private final Boolean analyzeWildcard;
    @Nullable
    private final Boolean autoGenerateSynonymsPhraseQuery;
    @Nullable
    private final String defaultField;
    @Nullable
    private final Operator defaultOperator;
    @Nullable
    private final Boolean enablePositionIncrements;
    @Nullable
    private final Boolean escape;
    @Nullable
    private final List<String> fields;
    @Nullable
    private final String fuzziness;
    @Nullable
    private final Integer fuzzyMaxExpansions;
    @Nullable
    private final Integer fuzzyPrefixLength;
    @Nullable
    private final String fuzzyRewrite;
    @Nullable
    private final Boolean fuzzyTranspositions;
    @Nullable
    private final Boolean lenient;
    @Nullable
    private final Integer maxDeterminizedStates;
    @Nullable
    private final String minimumShouldMatch;
    @Nullable
    private final Double phraseSlop;
    private final String query;
    @Nullable
    private final String quoteAnalyzer;
    @Nullable
    private final String quoteFieldSuffix;
    @Nullable
    private final String rewrite;
    @Nullable
    private final Double tieBreaker;
    @Nullable
    private final String timeZone;
    @Nullable
    private final TextQueryType type;
    public static final JsonpDeserializer<QueryStringQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryStringQuery::setupQueryStringQueryDeserializer, Builder::build);

    public QueryStringQuery(Builder builder) {
        super(builder);
        this.allowLeadingWildcard = builder.allowLeadingWildcard;
        this.analyzer = builder.analyzer;
        this.analyzeWildcard = builder.analyzeWildcard;
        this.autoGenerateSynonymsPhraseQuery = builder.autoGenerateSynonymsPhraseQuery;
        this.defaultField = builder.defaultField;
        this.defaultOperator = builder.defaultOperator;
        this.enablePositionIncrements = builder.enablePositionIncrements;
        this.escape = builder.escape;
        this.fields = ModelTypeHelper.unmodifiable(builder.fields);
        this.fuzziness = builder.fuzziness;
        this.fuzzyMaxExpansions = builder.fuzzyMaxExpansions;
        this.fuzzyPrefixLength = builder.fuzzyPrefixLength;
        this.fuzzyRewrite = builder.fuzzyRewrite;
        this.fuzzyTranspositions = builder.fuzzyTranspositions;
        this.lenient = builder.lenient;
        this.maxDeterminizedStates = builder.maxDeterminizedStates;
        this.minimumShouldMatch = builder.minimumShouldMatch;
        this.phraseSlop = builder.phraseSlop;
        this.query = Objects.requireNonNull(builder.query, "query");
        this.quoteAnalyzer = builder.quoteAnalyzer;
        this.quoteFieldSuffix = builder.quoteFieldSuffix;
        this.rewrite = builder.rewrite;
        this.tieBreaker = builder.tieBreaker;
        this.timeZone = builder.timeZone;
        this.type = builder.type;
    }

    public QueryStringQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "query_string";
    }

    @Nullable
    public Boolean allowLeadingWildcard() {
        return this.allowLeadingWildcard;
    }

    @Nullable
    public String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public Boolean analyzeWildcard() {
        return this.analyzeWildcard;
    }

    @Nullable
    public Boolean autoGenerateSynonymsPhraseQuery() {
        return this.autoGenerateSynonymsPhraseQuery;
    }

    @Nullable
    public String defaultField() {
        return this.defaultField;
    }

    @Nullable
    public Operator defaultOperator() {
        return this.defaultOperator;
    }

    @Nullable
    public Boolean enablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    @Nullable
    public Boolean escape() {
        return this.escape;
    }

    @Nullable
    public List<String> fields() {
        return this.fields;
    }

    @Nullable
    public String fuzziness() {
        return this.fuzziness;
    }

    @Nullable
    public Integer fuzzyMaxExpansions() {
        return this.fuzzyMaxExpansions;
    }

    @Nullable
    public Integer fuzzyPrefixLength() {
        return this.fuzzyPrefixLength;
    }

    @Nullable
    public String fuzzyRewrite() {
        return this.fuzzyRewrite;
    }

    @Nullable
    public Boolean fuzzyTranspositions() {
        return this.fuzzyTranspositions;
    }

    @Nullable
    public Boolean lenient() {
        return this.lenient;
    }

    @Nullable
    public Integer maxDeterminizedStates() {
        return this.maxDeterminizedStates;
    }

    @Nullable
    public String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    @Nullable
    public Double phraseSlop() {
        return this.phraseSlop;
    }

    public String query() {
        return this.query;
    }

    @Nullable
    public String quoteAnalyzer() {
        return this.quoteAnalyzer;
    }

    @Nullable
    public String quoteFieldSuffix() {
        return this.quoteFieldSuffix;
    }

    @Nullable
    public String rewrite() {
        return this.rewrite;
    }

    @Nullable
    public Double tieBreaker() {
        return this.tieBreaker;
    }

    @Nullable
    public String timeZone() {
        return this.timeZone;
    }

    @Nullable
    public TextQueryType type() {
        return this.type;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.allowLeadingWildcard != null) {
            generator.writeKey("allow_leading_wildcard");
            generator.write(this.allowLeadingWildcard.booleanValue());
        }
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.analyzeWildcard != null) {
            generator.writeKey("analyze_wildcard");
            generator.write(this.analyzeWildcard.booleanValue());
        }
        if (this.autoGenerateSynonymsPhraseQuery != null) {
            generator.writeKey("auto_generate_synonyms_phrase_query");
            generator.write(this.autoGenerateSynonymsPhraseQuery.booleanValue());
        }
        if (this.defaultField != null) {
            generator.writeKey("default_field");
            generator.write(this.defaultField);
        }
        if (this.defaultOperator != null) {
            generator.writeKey("default_operator");
            this.defaultOperator.serialize(generator, mapper);
        }
        if (this.enablePositionIncrements != null) {
            generator.writeKey("enable_position_increments");
            generator.write(this.enablePositionIncrements.booleanValue());
        }
        if (this.escape != null) {
            generator.writeKey("escape");
            generator.write(this.escape.booleanValue());
        }
        if (this.fields != null) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (String item0 : this.fields) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.fuzziness != null) {
            generator.writeKey("fuzziness");
            generator.write(this.fuzziness);
        }
        if (this.fuzzyMaxExpansions != null) {
            generator.writeKey("fuzzy_max_expansions");
            generator.write(this.fuzzyMaxExpansions.intValue());
        }
        if (this.fuzzyPrefixLength != null) {
            generator.writeKey("fuzzy_prefix_length");
            generator.write(this.fuzzyPrefixLength.intValue());
        }
        if (this.fuzzyRewrite != null) {
            generator.writeKey("fuzzy_rewrite");
            generator.write(this.fuzzyRewrite);
        }
        if (this.fuzzyTranspositions != null) {
            generator.writeKey("fuzzy_transpositions");
            generator.write(this.fuzzyTranspositions.booleanValue());
        }
        if (this.lenient != null) {
            generator.writeKey("lenient");
            generator.write(this.lenient.booleanValue());
        }
        if (this.maxDeterminizedStates != null) {
            generator.writeKey("max_determinized_states");
            generator.write(this.maxDeterminizedStates.intValue());
        }
        if (this.minimumShouldMatch != null) {
            generator.writeKey("minimum_should_match");
            generator.write(this.minimumShouldMatch);
        }
        if (this.phraseSlop != null) {
            generator.writeKey("phrase_slop");
            generator.write(this.phraseSlop.doubleValue());
        }
        generator.writeKey("query");
        generator.write(this.query);
        if (this.quoteAnalyzer != null) {
            generator.writeKey("quote_analyzer");
            generator.write(this.quoteAnalyzer);
        }
        if (this.quoteFieldSuffix != null) {
            generator.writeKey("quote_field_suffix");
            generator.write(this.quoteFieldSuffix);
        }
        if (this.rewrite != null) {
            generator.writeKey("rewrite");
            generator.write(this.rewrite);
        }
        if (this.tieBreaker != null) {
            generator.writeKey("tie_breaker");
            generator.write(this.tieBreaker.doubleValue());
        }
        if (this.timeZone != null) {
            generator.writeKey("time_zone");
            generator.write(this.timeZone);
        }
        if (this.type != null) {
            generator.writeKey("type");
            this.type.serialize(generator, mapper);
        }
    }

    protected static void setupQueryStringQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::allowLeadingWildcard, JsonpDeserializer.booleanDeserializer(), "allow_leading_wildcard", new String[0]);
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer", new String[0]);
        op.add(Builder::analyzeWildcard, JsonpDeserializer.booleanDeserializer(), "analyze_wildcard", new String[0]);
        op.add(Builder::autoGenerateSynonymsPhraseQuery, JsonpDeserializer.booleanDeserializer(), "auto_generate_synonyms_phrase_query", new String[0]);
        op.add(Builder::defaultField, JsonpDeserializer.stringDeserializer(), "default_field", new String[0]);
        op.add(Builder::defaultOperator, Operator._DESERIALIZER, "default_operator", new String[0]);
        op.add(Builder::enablePositionIncrements, JsonpDeserializer.booleanDeserializer(), "enable_position_increments", new String[0]);
        op.add(Builder::escape, JsonpDeserializer.booleanDeserializer(), "escape", new String[0]);
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields", new String[0]);
        op.add(Builder::fuzziness, JsonpDeserializer.stringDeserializer(), "fuzziness", new String[0]);
        op.add(Builder::fuzzyMaxExpansions, JsonpDeserializer.integerDeserializer(), "fuzzy_max_expansions", new String[0]);
        op.add(Builder::fuzzyPrefixLength, JsonpDeserializer.integerDeserializer(), "fuzzy_prefix_length", new String[0]);
        op.add(Builder::fuzzyRewrite, JsonpDeserializer.stringDeserializer(), "fuzzy_rewrite", new String[0]);
        op.add(Builder::fuzzyTranspositions, JsonpDeserializer.booleanDeserializer(), "fuzzy_transpositions", new String[0]);
        op.add(Builder::lenient, JsonpDeserializer.booleanDeserializer(), "lenient", new String[0]);
        op.add(Builder::maxDeterminizedStates, JsonpDeserializer.integerDeserializer(), "max_determinized_states", new String[0]);
        op.add(Builder::minimumShouldMatch, JsonpDeserializer.stringDeserializer(), "minimum_should_match", new String[0]);
        op.add(Builder::phraseSlop, JsonpDeserializer.doubleDeserializer(), "phrase_slop", new String[0]);
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query", new String[0]);
        op.add(Builder::quoteAnalyzer, JsonpDeserializer.stringDeserializer(), "quote_analyzer", new String[0]);
        op.add(Builder::quoteFieldSuffix, JsonpDeserializer.stringDeserializer(), "quote_field_suffix", new String[0]);
        op.add(Builder::rewrite, JsonpDeserializer.stringDeserializer(), "rewrite", new String[0]);
        op.add(Builder::tieBreaker, JsonpDeserializer.doubleDeserializer(), "tie_breaker", new String[0]);
        op.add(Builder::timeZone, JsonpDeserializer.stringDeserializer(), "time_zone", new String[0]);
        op.add(Builder::type, TextQueryType._DESERIALIZER, "type", new String[0]);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<QueryStringQuery> {
        @Nullable
        private Boolean allowLeadingWildcard;
        @Nullable
        private String analyzer;
        @Nullable
        private Boolean analyzeWildcard;
        @Nullable
        private Boolean autoGenerateSynonymsPhraseQuery;
        @Nullable
        private String defaultField;
        @Nullable
        private Operator defaultOperator;
        @Nullable
        private Boolean enablePositionIncrements;
        @Nullable
        private Boolean escape;
        @Nullable
        private List<String> fields;
        @Nullable
        private String fuzziness;
        @Nullable
        private Integer fuzzyMaxExpansions;
        @Nullable
        private Integer fuzzyPrefixLength;
        @Nullable
        private String fuzzyRewrite;
        @Nullable
        private Boolean fuzzyTranspositions;
        @Nullable
        private Boolean lenient;
        @Nullable
        private Integer maxDeterminizedStates;
        @Nullable
        private String minimumShouldMatch;
        @Nullable
        private Double phraseSlop;
        private String query;
        @Nullable
        private String quoteAnalyzer;
        @Nullable
        private String quoteFieldSuffix;
        @Nullable
        private String rewrite;
        @Nullable
        private Double tieBreaker;
        @Nullable
        private String timeZone;
        @Nullable
        private TextQueryType type;

        public Builder allowLeadingWildcard(@Nullable Boolean value) {
            this.allowLeadingWildcard = value;
            return this;
        }

        public Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public Builder analyzeWildcard(@Nullable Boolean value) {
            this.analyzeWildcard = value;
            return this;
        }

        public Builder autoGenerateSynonymsPhraseQuery(@Nullable Boolean value) {
            this.autoGenerateSynonymsPhraseQuery = value;
            return this;
        }

        public Builder defaultField(@Nullable String value) {
            this.defaultField = value;
            return this;
        }

        public Builder defaultOperator(@Nullable Operator value) {
            this.defaultOperator = value;
            return this;
        }

        public Builder enablePositionIncrements(@Nullable Boolean value) {
            this.enablePositionIncrements = value;
            return this;
        }

        public Builder escape(@Nullable Boolean value) {
            this.escape = value;
            return this;
        }

        public Builder fields(@Nullable List<String> value) {
            this.fields = value;
            return this;
        }

        public Builder fields(String ... value) {
            this.fields = Arrays.asList(value);
            return this;
        }

        public Builder addFields(String value) {
            if (this.fields == null) {
                this.fields = new ArrayList<String>();
            }
            this.fields.add(value);
            return this;
        }

        public Builder fuzziness(@Nullable String value) {
            this.fuzziness = value;
            return this;
        }

        public Builder fuzzyMaxExpansions(@Nullable Integer value) {
            this.fuzzyMaxExpansions = value;
            return this;
        }

        public Builder fuzzyPrefixLength(@Nullable Integer value) {
            this.fuzzyPrefixLength = value;
            return this;
        }

        public Builder fuzzyRewrite(@Nullable String value) {
            this.fuzzyRewrite = value;
            return this;
        }

        public Builder fuzzyTranspositions(@Nullable Boolean value) {
            this.fuzzyTranspositions = value;
            return this;
        }

        public Builder lenient(@Nullable Boolean value) {
            this.lenient = value;
            return this;
        }

        public Builder maxDeterminizedStates(@Nullable Integer value) {
            this.maxDeterminizedStates = value;
            return this;
        }

        public Builder minimumShouldMatch(@Nullable String value) {
            this.minimumShouldMatch = value;
            return this;
        }

        public Builder phraseSlop(@Nullable Double value) {
            this.phraseSlop = value;
            return this;
        }

        public Builder query(String value) {
            this.query = value;
            return this;
        }

        public Builder quoteAnalyzer(@Nullable String value) {
            this.quoteAnalyzer = value;
            return this;
        }

        public Builder quoteFieldSuffix(@Nullable String value) {
            this.quoteFieldSuffix = value;
            return this;
        }

        public Builder rewrite(@Nullable String value) {
            this.rewrite = value;
            return this;
        }

        public Builder tieBreaker(@Nullable Double value) {
            this.tieBreaker = value;
            return this;
        }

        public Builder timeZone(@Nullable String value) {
            this.timeZone = value;
            return this;
        }

        public Builder type(@Nullable TextQueryType value) {
            this.type = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public QueryStringQuery build() {
            return new QueryStringQuery(this);
        }
    }
}

