/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class PinnedDoc
implements JsonpSerializable {
    private final String id;
    private final String index;
    public static final JsonpDeserializer<PinnedDoc> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PinnedDoc::setupPinnedDocDeserializer, Builder::build);

    public PinnedDoc(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "_id");
        this.index = Objects.requireNonNull(builder.index, "_index");
    }

    public PinnedDoc(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    public String index() {
        return this.index;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_id");
        generator.write(this.id);
        generator.writeKey("_index");
        generator.write(this.index);
    }

    protected static void setupPinnedDocDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id", new String[0]);
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PinnedDoc> {
        private String id;
        private String index;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        @Override
        public PinnedDoc build() {
            return new PinnedDoc(this);
        }
    }
}

