/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsQueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class IntervalsFuzzy
implements IntervalsQueryVariant,
IntervalsVariant,
JsonpSerializable {
    @Nullable
    private final String analyzer;
    @Nullable
    private final String fuzziness;
    @Nullable
    private final Integer prefixLength;
    private final String term;
    @Nullable
    private final Boolean transpositions;
    @Nullable
    private final String useField;
    public static final JsonpDeserializer<IntervalsFuzzy> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IntervalsFuzzy::setupIntervalsFuzzyDeserializer, Builder::build);

    public IntervalsFuzzy(Builder builder) {
        this.analyzer = builder.analyzer;
        this.fuzziness = builder.fuzziness;
        this.prefixLength = builder.prefixLength;
        this.term = Objects.requireNonNull(builder.term, "term");
        this.transpositions = builder.transpositions;
        this.useField = builder.useField;
    }

    public IntervalsFuzzy(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "fuzzy";
    }

    @Nullable
    public String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public String fuzziness() {
        return this.fuzziness;
    }

    @Nullable
    public Integer prefixLength() {
        return this.prefixLength;
    }

    public String term() {
        return this.term;
    }

    @Nullable
    public Boolean transpositions() {
        return this.transpositions;
    }

    @Nullable
    public String useField() {
        return this.useField;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.fuzziness != null) {
            generator.writeKey("fuzziness");
            generator.write(this.fuzziness);
        }
        if (this.prefixLength != null) {
            generator.writeKey("prefix_length");
            generator.write(this.prefixLength.intValue());
        }
        generator.writeKey("term");
        generator.write(this.term);
        if (this.transpositions != null) {
            generator.writeKey("transpositions");
            generator.write(this.transpositions.booleanValue());
        }
        if (this.useField != null) {
            generator.writeKey("use_field");
            generator.write(this.useField);
        }
    }

    protected static void setupIntervalsFuzzyDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer", new String[0]);
        op.add(Builder::fuzziness, JsonpDeserializer.stringDeserializer(), "fuzziness", new String[0]);
        op.add(Builder::prefixLength, JsonpDeserializer.integerDeserializer(), "prefix_length", new String[0]);
        op.add(Builder::term, JsonpDeserializer.stringDeserializer(), "term", new String[0]);
        op.add(Builder::transpositions, JsonpDeserializer.booleanDeserializer(), "transpositions", new String[0]);
        op.add(Builder::useField, JsonpDeserializer.stringDeserializer(), "use_field", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<IntervalsFuzzy> {
        @Nullable
        private String analyzer;
        @Nullable
        private String fuzziness;
        @Nullable
        private Integer prefixLength;
        private String term;
        @Nullable
        private Boolean transpositions;
        @Nullable
        private String useField;

        public Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public Builder fuzziness(@Nullable String value) {
            this.fuzziness = value;
            return this;
        }

        public Builder prefixLength(@Nullable Integer value) {
            this.prefixLength = value;
            return this;
        }

        public Builder term(String value) {
            this.term = value;
            return this;
        }

        public Builder transpositions(@Nullable Boolean value) {
            this.transpositions = value;
            return this;
        }

        public Builder useField(@Nullable String value) {
            this.useField = value;
            return this;
        }

        @Override
        public IntervalsFuzzy build() {
            return new IntervalsFuzzy(this);
        }
    }
}

