/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Intervals;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class IntervalsFilter
implements TaggedUnion<Object>,
JsonpSerializable {
    public static final String AFTER = "after";
    public static final String BEFORE = "before";
    public static final String CONTAINED_BY = "contained_by";
    public static final String CONTAINING = "containing";
    public static final String NOT_CONTAINED_BY = "not_contained_by";
    public static final String NOT_CONTAINING = "not_containing";
    public static final String NOT_OVERLAPPING = "not_overlapping";
    public static final String OVERLAPPING = "overlapping";
    public static final String SCRIPT = "script";
    private final String _type;
    private final Object _value;
    public static final JsonpDeserializer<IntervalsFilter> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, IntervalsFilter::setupIntervalsFilterDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public Object _get() {
        return this._value;
    }

    public IntervalsFilter(IntervalsFilterVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    public <T extends IntervalsFilterVariant> IntervalsFilter(ObjectBuilder<T> builder) {
        this((IntervalsFilterVariant)builder.build());
    }

    private IntervalsFilter(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public IntervalsFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Intervals after() {
        return (Intervals)TaggedUnionUtils.get(this, AFTER);
    }

    public Intervals before() {
        return (Intervals)TaggedUnionUtils.get(this, BEFORE);
    }

    public Intervals containedBy() {
        return (Intervals)TaggedUnionUtils.get(this, CONTAINED_BY);
    }

    public Intervals containing() {
        return (Intervals)TaggedUnionUtils.get(this, CONTAINING);
    }

    public Intervals notContainedBy() {
        return (Intervals)TaggedUnionUtils.get(this, NOT_CONTAINED_BY);
    }

    public Intervals notContaining() {
        return (Intervals)TaggedUnionUtils.get(this, NOT_CONTAINING);
    }

    public Intervals notOverlapping() {
        return (Intervals)TaggedUnionUtils.get(this, NOT_OVERLAPPING);
    }

    public Intervals overlapping() {
        return (Intervals)TaggedUnionUtils.get(this, OVERLAPPING);
    }

    public JsonValue script() {
        return (JsonValue)TaggedUnionUtils.get(this, SCRIPT);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._type);
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._type) {
                case "script": {
                    generator.write((JsonValue)this._value);
                }
            }
        }
        generator.writeEnd();
    }

    protected static void setupIntervalsFilterDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::after, Intervals._DESERIALIZER, AFTER, new String[0]);
        op.add(Builder::before, Intervals._DESERIALIZER, BEFORE, new String[0]);
        op.add(Builder::containedBy, Intervals._DESERIALIZER, CONTAINED_BY, new String[0]);
        op.add(Builder::containing, Intervals._DESERIALIZER, CONTAINING, new String[0]);
        op.add(Builder::notContainedBy, Intervals._DESERIALIZER, NOT_CONTAINED_BY, new String[0]);
        op.add(Builder::notContaining, Intervals._DESERIALIZER, NOT_CONTAINING, new String[0]);
        op.add(Builder::notOverlapping, Intervals._DESERIALIZER, NOT_OVERLAPPING, new String[0]);
        op.add(Builder::overlapping, Intervals._DESERIALIZER, OVERLAPPING, new String[0]);
        op.add(Builder::script, JsonpDeserializer.jsonValueDeserializer(), SCRIPT, new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<IntervalsFilter> {
        private String _type;
        private Object _value;

        public Builder after(Intervals v) {
            this._type = IntervalsFilter.AFTER;
            this._value = v;
            return this;
        }

        public Builder after(Function<Intervals.Builder, ObjectBuilder<Intervals>> f) {
            return this.after(f.apply(new Intervals.Builder()).build());
        }

        public Builder before(Intervals v) {
            this._type = IntervalsFilter.BEFORE;
            this._value = v;
            return this;
        }

        public Builder before(Function<Intervals.Builder, ObjectBuilder<Intervals>> f) {
            return this.before(f.apply(new Intervals.Builder()).build());
        }

        public Builder containedBy(Intervals v) {
            this._type = IntervalsFilter.CONTAINED_BY;
            this._value = v;
            return this;
        }

        public Builder containedBy(Function<Intervals.Builder, ObjectBuilder<Intervals>> f) {
            return this.containedBy(f.apply(new Intervals.Builder()).build());
        }

        public Builder containing(Intervals v) {
            this._type = IntervalsFilter.CONTAINING;
            this._value = v;
            return this;
        }

        public Builder containing(Function<Intervals.Builder, ObjectBuilder<Intervals>> f) {
            return this.containing(f.apply(new Intervals.Builder()).build());
        }

        public Builder notContainedBy(Intervals v) {
            this._type = IntervalsFilter.NOT_CONTAINED_BY;
            this._value = v;
            return this;
        }

        public Builder notContainedBy(Function<Intervals.Builder, ObjectBuilder<Intervals>> f) {
            return this.notContainedBy(f.apply(new Intervals.Builder()).build());
        }

        public Builder notContaining(Intervals v) {
            this._type = IntervalsFilter.NOT_CONTAINING;
            this._value = v;
            return this;
        }

        public Builder notContaining(Function<Intervals.Builder, ObjectBuilder<Intervals>> f) {
            return this.notContaining(f.apply(new Intervals.Builder()).build());
        }

        public Builder notOverlapping(Intervals v) {
            this._type = IntervalsFilter.NOT_OVERLAPPING;
            this._value = v;
            return this;
        }

        public Builder notOverlapping(Function<Intervals.Builder, ObjectBuilder<Intervals>> f) {
            return this.notOverlapping(f.apply(new Intervals.Builder()).build());
        }

        public Builder overlapping(Intervals v) {
            this._type = IntervalsFilter.OVERLAPPING;
            this._value = v;
            return this;
        }

        public Builder overlapping(Function<Intervals.Builder, ObjectBuilder<Intervals>> f) {
            return this.overlapping(f.apply(new Intervals.Builder()).build());
        }

        public Builder script(JsonValue v) {
            this._type = IntervalsFilter.SCRIPT;
            this._value = v;
            return this;
        }

        @Override
        public IntervalsFilter build() {
            return new IntervalsFilter(this);
        }
    }
}

