/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class FuzzyQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    @Nullable
    private final Integer maxExpansions;
    @Nullable
    private final Integer prefixLength;
    @Nullable
    private final String rewrite;
    @Nullable
    private final Boolean transpositions;
    @Nullable
    private final String fuzziness;
    private final String value;
    public static final JsonpDeserializer<FuzzyQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FuzzyQuery::setupFuzzyQueryDeserializer, Builder::build);

    public FuzzyQuery(Builder builder) {
        super(builder);
        this.field = Objects.requireNonNull(builder.field, "field");
        this.maxExpansions = builder.maxExpansions;
        this.prefixLength = builder.prefixLength;
        this.rewrite = builder.rewrite;
        this.transpositions = builder.transpositions;
        this.fuzziness = builder.fuzziness;
        this.value = Objects.requireNonNull(builder.value, "value");
    }

    public FuzzyQuery(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "fuzzy";
    }

    public String field() {
        return this.field;
    }

    @Nullable
    public Integer maxExpansions() {
        return this.maxExpansions;
    }

    @Nullable
    public Integer prefixLength() {
        return this.prefixLength;
    }

    @Nullable
    public String rewrite() {
        return this.rewrite;
    }

    @Nullable
    public Boolean transpositions() {
        return this.transpositions;
    }

    @Nullable
    public String fuzziness() {
        return this.fuzziness;
    }

    public String value() {
        return this.value;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        if (this.maxExpansions != null) {
            generator.writeKey("max_expansions");
            generator.write(this.maxExpansions.intValue());
        }
        if (this.prefixLength != null) {
            generator.writeKey("prefix_length");
            generator.write(this.prefixLength.intValue());
        }
        if (this.rewrite != null) {
            generator.writeKey("rewrite");
            generator.write(this.rewrite);
        }
        if (this.transpositions != null) {
            generator.writeKey("transpositions");
            generator.write(this.transpositions.booleanValue());
        }
        if (this.fuzziness != null) {
            generator.writeKey("fuzziness");
            generator.write(this.fuzziness);
        }
        generator.writeKey("value");
        generator.write(this.value);
        generator.writeEnd();
    }

    protected static void setupFuzzyQueryDeserializer(DelegatingDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::maxExpansions, JsonpDeserializer.integerDeserializer(), "max_expansions", new String[0]);
        op.add(Builder::prefixLength, JsonpDeserializer.integerDeserializer(), "prefix_length", new String[0]);
        op.add(Builder::rewrite, JsonpDeserializer.stringDeserializer(), "rewrite", new String[0]);
        op.add(Builder::transpositions, JsonpDeserializer.booleanDeserializer(), "transpositions", new String[0]);
        op.add(Builder::fuzziness, JsonpDeserializer.stringDeserializer(), "fuzziness", new String[0]);
        op.add(Builder::value, JsonpDeserializer.stringDeserializer(), "value", new String[0]);
        op.setKey(Builder::field);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<FuzzyQuery> {
        private String field;
        @Nullable
        private Integer maxExpansions;
        @Nullable
        private Integer prefixLength;
        @Nullable
        private String rewrite;
        @Nullable
        private Boolean transpositions;
        @Nullable
        private String fuzziness;
        private String value;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder maxExpansions(@Nullable Integer value) {
            this.maxExpansions = value;
            return this;
        }

        public Builder prefixLength(@Nullable Integer value) {
            this.prefixLength = value;
            return this;
        }

        public Builder rewrite(@Nullable String value) {
            this.rewrite = value;
            return this;
        }

        public Builder transpositions(@Nullable Boolean value) {
            this.transpositions = value;
            return this;
        }

        public Builder fuzziness(@Nullable String value) {
            this.fuzziness = value;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FuzzyQuery build() {
            return new FuzzyQuery(this);
        }
    }
}

