/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.CorePropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.IndexOptions;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.elasticsearch._types.mapping.TermVectorOption;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SearchAsYouTypeProperty
extends CorePropertyBase
implements PropertyVariant {
    @Nullable
    private final String analyzer;
    @Nullable
    private final Boolean index;
    @Nullable
    private final IndexOptions indexOptions;
    @Nullable
    private final Integer maxShingleSize;
    @Nullable
    private final Boolean norms;
    @Nullable
    private final String searchAnalyzer;
    @Nullable
    private final String searchQuoteAnalyzer;
    @Nullable
    private final TermVectorOption termVector;
    public static final JsonpDeserializer<SearchAsYouTypeProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchAsYouTypeProperty::setupSearchAsYouTypePropertyDeserializer, Builder::build);

    public SearchAsYouTypeProperty(Builder builder) {
        super(builder);
        this.analyzer = builder.analyzer;
        this.index = builder.index;
        this.indexOptions = builder.indexOptions;
        this.maxShingleSize = builder.maxShingleSize;
        this.norms = builder.norms;
        this.searchAnalyzer = builder.searchAnalyzer;
        this.searchQuoteAnalyzer = builder.searchQuoteAnalyzer;
        this.termVector = builder.termVector;
    }

    public SearchAsYouTypeProperty(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "search_as_you_type";
    }

    @Nullable
    public String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public Boolean index() {
        return this.index;
    }

    @Nullable
    public IndexOptions indexOptions() {
        return this.indexOptions;
    }

    @Nullable
    public Integer maxShingleSize() {
        return this.maxShingleSize;
    }

    @Nullable
    public Boolean norms() {
        return this.norms;
    }

    @Nullable
    public String searchAnalyzer() {
        return this.searchAnalyzer;
    }

    @Nullable
    public String searchQuoteAnalyzer() {
        return this.searchQuoteAnalyzer;
    }

    @Nullable
    public TermVectorOption termVector() {
        return this.termVector;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "search_as_you_type");
        super.serializeInternal(generator, mapper);
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index.booleanValue());
        }
        if (this.indexOptions != null) {
            generator.writeKey("index_options");
            this.indexOptions.serialize(generator, mapper);
        }
        if (this.maxShingleSize != null) {
            generator.writeKey("max_shingle_size");
            generator.write(this.maxShingleSize.intValue());
        }
        if (this.norms != null) {
            generator.writeKey("norms");
            generator.write(this.norms.booleanValue());
        }
        if (this.searchAnalyzer != null) {
            generator.writeKey("search_analyzer");
            generator.write(this.searchAnalyzer);
        }
        if (this.searchQuoteAnalyzer != null) {
            generator.writeKey("search_quote_analyzer");
            generator.write(this.searchQuoteAnalyzer);
        }
        if (this.termVector != null) {
            generator.writeKey("term_vector");
            this.termVector.serialize(generator, mapper);
        }
    }

    protected static void setupSearchAsYouTypePropertyDeserializer(DelegatingDeserializer<Builder> op) {
        CorePropertyBase.setupCorePropertyBaseDeserializer(op);
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer", new String[0]);
        op.add(Builder::index, JsonpDeserializer.booleanDeserializer(), "index", new String[0]);
        op.add(Builder::indexOptions, IndexOptions._DESERIALIZER, "index_options", new String[0]);
        op.add(Builder::maxShingleSize, JsonpDeserializer.integerDeserializer(), "max_shingle_size", new String[0]);
        op.add(Builder::norms, JsonpDeserializer.booleanDeserializer(), "norms", new String[0]);
        op.add(Builder::searchAnalyzer, JsonpDeserializer.stringDeserializer(), "search_analyzer", new String[0]);
        op.add(Builder::searchQuoteAnalyzer, JsonpDeserializer.stringDeserializer(), "search_quote_analyzer", new String[0]);
        op.add(Builder::termVector, TermVectorOption._DESERIALIZER, "term_vector", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends CorePropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SearchAsYouTypeProperty> {
        @Nullable
        private String analyzer;
        @Nullable
        private Boolean index;
        @Nullable
        private IndexOptions indexOptions;
        @Nullable
        private Integer maxShingleSize;
        @Nullable
        private Boolean norms;
        @Nullable
        private String searchAnalyzer;
        @Nullable
        private String searchQuoteAnalyzer;
        @Nullable
        private TermVectorOption termVector;

        public Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public Builder index(@Nullable Boolean value) {
            this.index = value;
            return this;
        }

        public Builder indexOptions(@Nullable IndexOptions value) {
            this.indexOptions = value;
            return this;
        }

        public Builder maxShingleSize(@Nullable Integer value) {
            this.maxShingleSize = value;
            return this;
        }

        public Builder norms(@Nullable Boolean value) {
            this.norms = value;
            return this;
        }

        public Builder searchAnalyzer(@Nullable String value) {
            this.searchAnalyzer = value;
            return this;
        }

        public Builder searchQuoteAnalyzer(@Nullable String value) {
            this.searchQuoteAnalyzer = value;
            return this;
        }

        public Builder termVector(@Nullable TermVectorOption value) {
            this.termVector = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SearchAsYouTypeProperty build() {
            return new SearchAsYouTypeProperty(this);
        }
    }
}

