/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.CorePropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ObjectProperty
extends CorePropertyBase
implements PropertyVariant {
    @Nullable
    private final Boolean enabled;
    public static final JsonpDeserializer<ObjectProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ObjectProperty::setupObjectPropertyDeserializer, Builder::build);

    public ObjectProperty(Builder builder) {
        super(builder);
        this.enabled = builder.enabled;
    }

    public ObjectProperty(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "object";
    }

    @Nullable
    public Boolean enabled() {
        return this.enabled;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "object");
        super.serializeInternal(generator, mapper);
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled.booleanValue());
        }
    }

    protected static void setupObjectPropertyDeserializer(DelegatingDeserializer<Builder> op) {
        CorePropertyBase.setupCorePropertyBaseDeserializer(op);
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends CorePropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ObjectProperty> {
        @Nullable
        private Boolean enabled;

        public Builder enabled(@Nullable Boolean value) {
            this.enabled = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ObjectProperty build() {
            return new ObjectProperty(this);
        }
    }
}

