/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenizerBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class StandardTokenizer
extends TokenizerBase
implements TokenizerVariant {
    private final int maxTokenLength;
    public static final JsonpDeserializer<StandardTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StandardTokenizer::setupStandardTokenizerDeserializer, Builder::build);

    public StandardTokenizer(Builder builder) {
        super(builder);
        this.maxTokenLength = Objects.requireNonNull(builder.maxTokenLength, "max_token_length");
    }

    public StandardTokenizer(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "standard";
    }

    public int maxTokenLength() {
        return this.maxTokenLength;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "standard");
        super.serializeInternal(generator, mapper);
        generator.writeKey("max_token_length");
        generator.write(this.maxTokenLength);
    }

    protected static void setupStandardTokenizerDeserializer(DelegatingDeserializer<Builder> op) {
        TokenizerBase.setupTokenizerBaseDeserializer(op);
        op.add(Builder::maxTokenLength, JsonpDeserializer.integerDeserializer(), "max_token_length", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements ObjectBuilder<StandardTokenizer> {
        private Integer maxTokenLength;

        public Builder maxTokenLength(int value) {
            this.maxTokenLength = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StandardTokenizer build() {
            return new StandardTokenizer(this);
        }
    }
}

