/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.AnalyzerVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class PatternAnalyzer
implements AnalyzerVariant,
JsonpSerializable {
    private final String version;
    private final String flags;
    private final boolean lowercase;
    private final String pattern;
    private final List<String> stopwords;
    public static final JsonpDeserializer<PatternAnalyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PatternAnalyzer::setupPatternAnalyzerDeserializer, Builder::build);

    public PatternAnalyzer(Builder builder) {
        this.version = Objects.requireNonNull(builder.version, "version");
        this.flags = Objects.requireNonNull(builder.flags, "flags");
        this.lowercase = Objects.requireNonNull(builder.lowercase, "lowercase");
        this.pattern = Objects.requireNonNull(builder.pattern, "pattern");
        this.stopwords = ModelTypeHelper.unmodifiableNonNull(builder.stopwords, "stopwords");
    }

    public PatternAnalyzer(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "pattern";
    }

    public String version() {
        return this.version;
    }

    public String flags() {
        return this.flags;
    }

    public boolean lowercase() {
        return this.lowercase;
    }

    public String pattern() {
        return this.pattern;
    }

    public List<String> stopwords() {
        return this.stopwords;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "pattern");
        generator.writeKey("version");
        generator.write(this.version);
        generator.writeKey("flags");
        generator.write(this.flags);
        generator.writeKey("lowercase");
        generator.write(this.lowercase);
        generator.writeKey("pattern");
        generator.write(this.pattern);
        generator.writeKey("stopwords");
        generator.writeStartArray();
        for (String item0 : this.stopwords) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static void setupPatternAnalyzerDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version", new String[0]);
        op.add(Builder::flags, JsonpDeserializer.stringDeserializer(), "flags", new String[0]);
        op.add(Builder::lowercase, JsonpDeserializer.booleanDeserializer(), "lowercase", new String[0]);
        op.add(Builder::pattern, JsonpDeserializer.stringDeserializer(), "pattern", new String[0]);
        op.add(Builder::stopwords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stopwords", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    implements ObjectBuilder<PatternAnalyzer> {
        private String version;
        private String flags;
        private Boolean lowercase;
        private String pattern;
        private List<String> stopwords;

        public Builder version(String value) {
            this.version = value;
            return this;
        }

        public Builder flags(String value) {
            this.flags = value;
            return this;
        }

        public Builder lowercase(boolean value) {
            this.lowercase = value;
            return this;
        }

        public Builder pattern(String value) {
            this.pattern = value;
            return this;
        }

        public Builder stopwords(List<String> value) {
            this.stopwords = value;
            return this;
        }

        public Builder stopwords(String ... value) {
            this.stopwords = Arrays.asList(value);
            return this;
        }

        public Builder addStopwords(String value) {
            if (this.stopwords == null) {
                this.stopwords = new ArrayList<String>();
            }
            this.stopwords.add(value);
            return this;
        }

        @Override
        public PatternAnalyzer build() {
            return new PatternAnalyzer(this);
        }
    }
}

