/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.KuromojiTokenizationMode;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenizerVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class KuromojiTokenizer
extends TokenizerBase
implements TokenizerVariant {
    private final boolean discardPunctuation;
    private final KuromojiTokenizationMode mode;
    private final int nbestCost;
    private final String nbestExamples;
    private final String userDictionary;
    private final List<String> userDictionaryRules;
    public static final JsonpDeserializer<KuromojiTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KuromojiTokenizer::setupKuromojiTokenizerDeserializer, Builder::build);

    public KuromojiTokenizer(Builder builder) {
        super(builder);
        this.discardPunctuation = Objects.requireNonNull(builder.discardPunctuation, "discard_punctuation");
        this.mode = Objects.requireNonNull(builder.mode, "mode");
        this.nbestCost = Objects.requireNonNull(builder.nbestCost, "nbest_cost");
        this.nbestExamples = Objects.requireNonNull(builder.nbestExamples, "nbest_examples");
        this.userDictionary = Objects.requireNonNull(builder.userDictionary, "user_dictionary");
        this.userDictionaryRules = ModelTypeHelper.unmodifiableNonNull(builder.userDictionaryRules, "user_dictionary_rules");
    }

    public KuromojiTokenizer(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "kuromoji_tokenizer";
    }

    public boolean discardPunctuation() {
        return this.discardPunctuation;
    }

    public KuromojiTokenizationMode mode() {
        return this.mode;
    }

    public int nbestCost() {
        return this.nbestCost;
    }

    public String nbestExamples() {
        return this.nbestExamples;
    }

    public String userDictionary() {
        return this.userDictionary;
    }

    public List<String> userDictionaryRules() {
        return this.userDictionaryRules;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "kuromoji_tokenizer");
        super.serializeInternal(generator, mapper);
        generator.writeKey("discard_punctuation");
        generator.write(this.discardPunctuation);
        generator.writeKey("mode");
        this.mode.serialize(generator, mapper);
        generator.writeKey("nbest_cost");
        generator.write(this.nbestCost);
        generator.writeKey("nbest_examples");
        generator.write(this.nbestExamples);
        generator.writeKey("user_dictionary");
        generator.write(this.userDictionary);
        generator.writeKey("user_dictionary_rules");
        generator.writeStartArray();
        for (String item0 : this.userDictionaryRules) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static void setupKuromojiTokenizerDeserializer(DelegatingDeserializer<Builder> op) {
        TokenizerBase.setupTokenizerBaseDeserializer(op);
        op.add(Builder::discardPunctuation, JsonpDeserializer.booleanDeserializer(), "discard_punctuation", new String[0]);
        op.add(Builder::mode, KuromojiTokenizationMode._DESERIALIZER, "mode", new String[0]);
        op.add(Builder::nbestCost, JsonpDeserializer.integerDeserializer(), "nbest_cost", new String[0]);
        op.add(Builder::nbestExamples, JsonpDeserializer.stringDeserializer(), "nbest_examples", new String[0]);
        op.add(Builder::userDictionary, JsonpDeserializer.stringDeserializer(), "user_dictionary", new String[0]);
        op.add(Builder::userDictionaryRules, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "user_dictionary_rules", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements ObjectBuilder<KuromojiTokenizer> {
        private Boolean discardPunctuation;
        private KuromojiTokenizationMode mode;
        private Integer nbestCost;
        private String nbestExamples;
        private String userDictionary;
        private List<String> userDictionaryRules;

        public Builder discardPunctuation(boolean value) {
            this.discardPunctuation = value;
            return this;
        }

        public Builder mode(KuromojiTokenizationMode value) {
            this.mode = value;
            return this;
        }

        public Builder nbestCost(int value) {
            this.nbestCost = value;
            return this;
        }

        public Builder nbestExamples(String value) {
            this.nbestExamples = value;
            return this;
        }

        public Builder userDictionary(String value) {
            this.userDictionary = value;
            return this;
        }

        public Builder userDictionaryRules(List<String> value) {
            this.userDictionaryRules = value;
            return this;
        }

        public Builder userDictionaryRules(String ... value) {
            this.userDictionaryRules = Arrays.asList(value);
            return this;
        }

        public Builder addUserDictionaryRules(String value) {
            if (this.userDictionaryRules == null) {
                this.userDictionaryRules = new ArrayList<String>();
            }
            this.userDictionaryRules.add(value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KuromojiTokenizer build() {
            return new KuromojiTokenizer(this);
        }
    }
}

