/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class KeywordMarkerTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    private final boolean ignoreCase;
    private final List<String> keywords;
    private final String keywordsPath;
    private final String keywordsPattern;
    public static final JsonpDeserializer<KeywordMarkerTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KeywordMarkerTokenFilter::setupKeywordMarkerTokenFilterDeserializer, Builder::build);

    public KeywordMarkerTokenFilter(Builder builder) {
        super(builder);
        this.ignoreCase = Objects.requireNonNull(builder.ignoreCase, "ignore_case");
        this.keywords = ModelTypeHelper.unmodifiableNonNull(builder.keywords, "keywords");
        this.keywordsPath = Objects.requireNonNull(builder.keywordsPath, "keywords_path");
        this.keywordsPattern = Objects.requireNonNull(builder.keywordsPattern, "keywords_pattern");
    }

    public KeywordMarkerTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "keyword_marker";
    }

    public boolean ignoreCase() {
        return this.ignoreCase;
    }

    public List<String> keywords() {
        return this.keywords;
    }

    public String keywordsPath() {
        return this.keywordsPath;
    }

    public String keywordsPattern() {
        return this.keywordsPattern;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "keyword_marker");
        super.serializeInternal(generator, mapper);
        generator.writeKey("ignore_case");
        generator.write(this.ignoreCase);
        generator.writeKey("keywords");
        generator.writeStartArray();
        for (String item0 : this.keywords) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("keywords_path");
        generator.write(this.keywordsPath);
        generator.writeKey("keywords_pattern");
        generator.write(this.keywordsPattern);
    }

    protected static void setupKeywordMarkerTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::ignoreCase, JsonpDeserializer.booleanDeserializer(), "ignore_case", new String[0]);
        op.add(Builder::keywords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "keywords", new String[0]);
        op.add(Builder::keywordsPath, JsonpDeserializer.stringDeserializer(), "keywords_path", new String[0]);
        op.add(Builder::keywordsPattern, JsonpDeserializer.stringDeserializer(), "keywords_pattern", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<KeywordMarkerTokenFilter> {
        private Boolean ignoreCase;
        private List<String> keywords;
        private String keywordsPath;
        private String keywordsPattern;

        public Builder ignoreCase(boolean value) {
            this.ignoreCase = value;
            return this;
        }

        public Builder keywords(List<String> value) {
            this.keywords = value;
            return this;
        }

        public Builder keywords(String ... value) {
            this.keywords = Arrays.asList(value);
            return this;
        }

        public Builder addKeywords(String value) {
            if (this.keywords == null) {
                this.keywords = new ArrayList<String>();
            }
            this.keywords.add(value);
            return this;
        }

        public Builder keywordsPath(String value) {
            this.keywordsPath = value;
            return this;
        }

        public Builder keywordsPattern(String value) {
            this.keywordsPattern = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KeywordMarkerTokenFilter build() {
            return new KeywordMarkerTokenFilter(this);
        }
    }
}

