/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.AnalyzerVariant;
import co.elastic.clients.elasticsearch._types.analysis.IcuNormalizationMode;
import co.elastic.clients.elasticsearch._types.analysis.IcuNormalizationType;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class IcuAnalyzer
implements AnalyzerVariant,
JsonpSerializable {
    private final IcuNormalizationType method;
    private final IcuNormalizationMode mode;
    public static final JsonpDeserializer<IcuAnalyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IcuAnalyzer::setupIcuAnalyzerDeserializer, Builder::build);

    public IcuAnalyzer(Builder builder) {
        this.method = Objects.requireNonNull(builder.method, "method");
        this.mode = Objects.requireNonNull(builder.mode, "mode");
    }

    public IcuAnalyzer(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "icu_analyzer";
    }

    public IcuNormalizationType method() {
        return this.method;
    }

    public IcuNormalizationMode mode() {
        return this.mode;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "icu_analyzer");
        generator.writeKey("method");
        this.method.serialize(generator, mapper);
        generator.writeKey("mode");
        this.mode.serialize(generator, mapper);
    }

    protected static void setupIcuAnalyzerDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::method, IcuNormalizationType._DESERIALIZER, "method", new String[0]);
        op.add(Builder::mode, IcuNormalizationMode._DESERIALIZER, "mode", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    implements ObjectBuilder<IcuAnalyzer> {
        private IcuNormalizationType method;
        private IcuNormalizationMode mode;

        public Builder method(IcuNormalizationType value) {
            this.method = value;
            return this;
        }

        public Builder mode(IcuNormalizationMode value) {
            this.mode = value;
            return this;
        }

        @Override
        public IcuAnalyzer build() {
            return new IcuAnalyzer(this);
        }
    }
}

