/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.AnalyzerVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class FingerprintAnalyzer
implements AnalyzerVariant,
JsonpSerializable {
    private final String version;
    private final int maxOutputSize;
    private final boolean preserveOriginal;
    private final String separator;
    private final List<String> stopwords;
    private final String stopwordsPath;
    public static final JsonpDeserializer<FingerprintAnalyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FingerprintAnalyzer::setupFingerprintAnalyzerDeserializer, Builder::build);

    public FingerprintAnalyzer(Builder builder) {
        this.version = Objects.requireNonNull(builder.version, "version");
        this.maxOutputSize = Objects.requireNonNull(builder.maxOutputSize, "max_output_size");
        this.preserveOriginal = Objects.requireNonNull(builder.preserveOriginal, "preserve_original");
        this.separator = Objects.requireNonNull(builder.separator, "separator");
        this.stopwords = ModelTypeHelper.unmodifiableNonNull(builder.stopwords, "stopwords");
        this.stopwordsPath = Objects.requireNonNull(builder.stopwordsPath, "stopwords_path");
    }

    public FingerprintAnalyzer(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "fingerprint";
    }

    public String version() {
        return this.version;
    }

    public int maxOutputSize() {
        return this.maxOutputSize;
    }

    public boolean preserveOriginal() {
        return this.preserveOriginal;
    }

    public String separator() {
        return this.separator;
    }

    public List<String> stopwords() {
        return this.stopwords;
    }

    public String stopwordsPath() {
        return this.stopwordsPath;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "fingerprint");
        generator.writeKey("version");
        generator.write(this.version);
        generator.writeKey("max_output_size");
        generator.write(this.maxOutputSize);
        generator.writeKey("preserve_original");
        generator.write(this.preserveOriginal);
        generator.writeKey("separator");
        generator.write(this.separator);
        generator.writeKey("stopwords");
        generator.writeStartArray();
        for (String item0 : this.stopwords) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("stopwords_path");
        generator.write(this.stopwordsPath);
    }

    protected static void setupFingerprintAnalyzerDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version", new String[0]);
        op.add(Builder::maxOutputSize, JsonpDeserializer.integerDeserializer(), "max_output_size", new String[0]);
        op.add(Builder::preserveOriginal, JsonpDeserializer.booleanDeserializer(), "preserve_original", new String[0]);
        op.add(Builder::separator, JsonpDeserializer.stringDeserializer(), "separator", new String[0]);
        op.add(Builder::stopwords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stopwords", new String[0]);
        op.add(Builder::stopwordsPath, JsonpDeserializer.stringDeserializer(), "stopwords_path", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    implements ObjectBuilder<FingerprintAnalyzer> {
        private String version;
        private Integer maxOutputSize;
        private Boolean preserveOriginal;
        private String separator;
        private List<String> stopwords;
        private String stopwordsPath;

        public Builder version(String value) {
            this.version = value;
            return this;
        }

        public Builder maxOutputSize(int value) {
            this.maxOutputSize = value;
            return this;
        }

        public Builder preserveOriginal(boolean value) {
            this.preserveOriginal = value;
            return this;
        }

        public Builder separator(String value) {
            this.separator = value;
            return this;
        }

        public Builder stopwords(List<String> value) {
            this.stopwords = value;
            return this;
        }

        public Builder stopwords(String ... value) {
            this.stopwords = Arrays.asList(value);
            return this;
        }

        public Builder addStopwords(String value) {
            if (this.stopwords == null) {
                this.stopwords = new ArrayList<String>();
            }
            this.stopwords.add(value);
            return this;
        }

        public Builder stopwordsPath(String value) {
            this.stopwordsPath = value;
            return this;
        }

        @Override
        public FingerprintAnalyzer build() {
            return new FingerprintAnalyzer(this);
        }
    }
}

