/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.MetricAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.TopMetricsValue;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class TopMetricsAggregation
extends MetricAggregationBase
implements AggregationVariant {
    @Nullable
    private final List<TopMetricsValue> metrics;
    @Nullable
    private final Integer size;
    @Nullable
    private final List<JsonValue> sort;
    public static final JsonpDeserializer<TopMetricsAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TopMetricsAggregation::setupTopMetricsAggregationDeserializer, Builder::build);

    public TopMetricsAggregation(Builder builder) {
        super(builder);
        this.metrics = ModelTypeHelper.unmodifiable(builder.metrics);
        this.size = builder.size;
        this.sort = ModelTypeHelper.unmodifiable(builder.sort);
    }

    public TopMetricsAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "top_metrics";
    }

    @Nullable
    public List<TopMetricsValue> metrics() {
        return this.metrics;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Nullable
    public List<JsonValue> sort() {
        return this.sort;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.metrics != null) {
            generator.writeKey("metrics");
            generator.writeStartArray();
            for (TopMetricsValue topMetricsValue : this.metrics) {
                topMetricsValue.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (this.sort != null) {
            generator.writeKey("sort");
            generator.writeStartArray();
            for (JsonValue jsonValue : this.sort) {
                generator.write(jsonValue);
            }
            generator.writeEnd();
        }
    }

    protected static void setupTopMetricsAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        MetricAggregationBase.setupMetricAggregationBaseDeserializer(op);
        op.add(Builder::metrics, JsonpDeserializer.arrayDeserializer(TopMetricsValue._DESERIALIZER), "metrics", new String[0]);
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size", new String[0]);
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.jsonValueDeserializer()), "sort", new String[0]);
    }

    public static class Builder
    extends MetricAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TopMetricsAggregation> {
        @Nullable
        private List<TopMetricsValue> metrics;
        @Nullable
        private Integer size;
        @Nullable
        private List<JsonValue> sort;

        public Builder metrics(@Nullable List<TopMetricsValue> value) {
            this.metrics = value;
            return this;
        }

        public Builder metrics(TopMetricsValue ... value) {
            this.metrics = Arrays.asList(value);
            return this;
        }

        public Builder addMetrics(TopMetricsValue value) {
            if (this.metrics == null) {
                this.metrics = new ArrayList<TopMetricsValue>();
            }
            this.metrics.add(value);
            return this;
        }

        public Builder metrics(Function<TopMetricsValue.Builder, ObjectBuilder<TopMetricsValue>> fn) {
            return this.metrics(fn.apply(new TopMetricsValue.Builder()).build());
        }

        public Builder addMetrics(Function<TopMetricsValue.Builder, ObjectBuilder<TopMetricsValue>> fn) {
            return this.addMetrics(fn.apply(new TopMetricsValue.Builder()).build());
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public Builder sort(@Nullable List<JsonValue> value) {
            this.sort = value;
            return this;
        }

        public Builder sort(JsonValue ... value) {
            this.sort = Arrays.asList(value);
            return this;
        }

        public Builder addSort(JsonValue value) {
            if (this.sort == null) {
                this.sort = new ArrayList<JsonValue>();
            }
            this.sort.add(value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TopMetricsAggregation build() {
            return new TopMetricsAggregation(this);
        }
    }
}

